/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms.bc;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSAlgorithm;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.bc.b;
import com.timevale.tgtext.bouncycastle.crypto.BufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherKeyGenerator;
import com.timevale.tgtext.bouncycastle.crypto.StreamCipher;
import com.timevale.tgtext.bouncycastle.crypto.io.CipherOutputStream;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.tgtext.bouncycastle.util.Integers;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class BcCMSContentEncryptorBuilder {
    private static Map keySizes = new HashMap<ASN1ObjectIdentifier, Integer>();
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private b helper = new b();
    private SecureRandom random;

    private static int getKeySize(ASN1ObjectIdentifier oid) {
        Integer size = (Integer)keySizes.get(oid);
        if (size != null) {
            return size;
        }
        return -1;
    }

    public BcCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, BcCMSContentEncryptorBuilder.getKeySize(encryptionOID));
    }

    public BcCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public BcCMSContentEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        return new a(this.encryptionOID, this.keySize, this.random);
    }

    static {
        keySizes.put(CMSAlgorithm.AES128_CBC, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.AES192_CBC, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.AES256_CBC, Integers.valueOf(256));
        keySizes.put(CMSAlgorithm.CAMELLIA128_CBC, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.CAMELLIA192_CBC, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.CAMELLIA256_CBC, Integers.valueOf(256));
    }

    private class a
    implements OutputEncryptor {
        private KeyParameter b;
        private AlgorithmIdentifier c;
        private Object d;

        a(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CMSException {
            if (random == null) {
                random = new SecureRandom();
            }
            CipherKeyGenerator keyGen = BcCMSContentEncryptorBuilder.this.helper.a(encryptionOID, random);
            this.b = new KeyParameter(keyGen.generateKey());
            this.c = BcCMSContentEncryptorBuilder.this.helper.a(encryptionOID, this.b, random);
            BcCMSContentEncryptorBuilder.this.helper;
            this.d = com.timevale.tgtext.bouncycastle.cms.bc.b.a(true, this.b, this.c);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.c;
        }

        @Override
        public OutputStream getOutputStream(OutputStream dOut) {
            if (this.d instanceof BufferedBlockCipher) {
                return new CipherOutputStream(dOut, (BufferedBlockCipher)this.d);
            }
            return new CipherOutputStream(dOut, (StreamCipher)this.d);
        }

        @Override
        public GenericKey getKey() {
            return new GenericKey(this.c, this.b.getKey());
        }
    }
}

