/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.CertStatus;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.RevokedInfo;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.SingleResponse;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.cert.ocsp.CertificateID;
import com.timevale.tgtext.bouncycastle.cert.ocsp.CertificateStatus;
import com.timevale.tgtext.bouncycastle.cert.ocsp.RevokedStatus;
import com.timevale.tgtext.bouncycastle.cert.ocsp.UnknownStatus;
import com.timevale.tgtext.bouncycastle.cert.ocsp.a;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class SingleResp {
    private SingleResponse resp;
    private Extensions extensions;

    public SingleResp(SingleResponse resp) {
        this.resp = resp;
        this.extensions = resp.getSingleExtensions();
    }

    public CertificateID getCertID() {
        return new CertificateID(this.resp.getCertID());
    }

    public CertificateStatus getCertStatus() {
        CertStatus s2 = this.resp.getCertStatus();
        if (s2.getTagNo() == 0) {
            return null;
        }
        if (s2.getTagNo() == 1) {
            return new RevokedStatus(RevokedInfo.getInstance(s2.getStatus()));
        }
        return new UnknownStatus();
    }

    public Date getThisUpdate() {
        return a.a(this.resp.getThisUpdate());
    }

    public Date getNextUpdate() {
        if (this.resp.getNextUpdate() == null) {
            return null;
        }
        return a.a(this.resp.getNextUpdate());
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return a.c(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return a.a(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return a.b(this.extensions);
    }
}

