/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.spec;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;

public class ECCKeyGenParameterSpec
implements AlgorithmParameterSpec {
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private int m;
    private int t;
    private int n;
    private int fieldPoly;

    public ECCKeyGenParameterSpec() {
        this(11, 50);
    }

    public ECCKeyGenParameterSpec(int keysize) throws InvalidParameterException {
        if (keysize <= 0) {
            throw new InvalidParameterException("key size must be positive");
        }
        this.m = 0;
        this.n = 1;
        while (this.n < keysize) {
            this.n <<= 1;
            ++this.m;
        }
        this.t = this.n >>> 1;
        this.t /= this.m;
        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(this.m);
    }

    public ECCKeyGenParameterSpec(int m2, int t2) throws InvalidParameterException {
        if (m2 <= 0) {
            throw new InvalidParameterException("m must be positive");
        }
        if (m2 > 32) {
            throw new InvalidParameterException("m is too large");
        }
        this.m = m2;
        this.n = 1 << m2;
        if (t2 < 0) {
            throw new InvalidParameterException("t must be positive");
        }
        if (t2 > this.n) {
            throw new InvalidParameterException("t must be less than n = 2^m");
        }
        this.t = t2;
        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(m2);
    }

    public ECCKeyGenParameterSpec(int m2, int t2, int poly) throws InvalidParameterException {
        this.m = m2;
        if (m2 <= 0) {
            throw new InvalidParameterException("m must be positive");
        }
        if (m2 > 32) {
            throw new InvalidParameterException(" m is too large");
        }
        this.n = 1 << m2;
        this.t = t2;
        if (t2 < 0) {
            throw new InvalidParameterException("t must be positive");
        }
        if (t2 > this.n) {
            throw new InvalidParameterException("t must be less than n = 2^m");
        }
        if (PolynomialRingGF2.degree(poly) == m2 && PolynomialRingGF2.isIrreducible(poly)) {
            this.fieldPoly = poly;
            return;
        }
        throw new InvalidParameterException("polynomial is not a field polynomial for GF(2^m)");
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public int getFieldPoly() {
        return this.fieldPoly;
    }
}

