/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class Permutation {
    private int[] perm;

    public Permutation(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n2];
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.perm[i2] = i2;
        }
    }

    public Permutation(int[] perm) {
        if (!this.isPermutation(perm)) {
            throw new IllegalArgumentException("array is not a permutation vector");
        }
        this.perm = IntUtils.clone(perm);
    }

    public Permutation(byte[] enc) {
        int size;
        if (enc.length <= 4) {
            throw new IllegalArgumentException("invalid encoding");
        }
        int n2 = LittleEndianConversions.OS2IP(enc, 0);
        if (enc.length != 4 + n2 * (size = IntegerFunctions.ceilLog256(n2 - 1))) {
            throw new IllegalArgumentException("invalid encoding");
        }
        this.perm = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.perm[i2] = LittleEndianConversions.OS2IP(enc, 4 + i2 * size, size);
        }
        if (!this.isPermutation(this.perm)) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public Permutation(int n2, SecureRandom sr) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n2];
        int[] help = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            help[i2] = i2;
        }
        int k2 = n2;
        for (int j2 = 0; j2 < n2; ++j2) {
            int i3 = RandUtils.nextInt(sr, k2);
            this.perm[j2] = help[i3];
            help[i3] = help[--k2];
        }
    }

    public byte[] getEncoded() {
        int n2 = this.perm.length;
        int size = IntegerFunctions.ceilLog256(n2 - 1);
        byte[] result = new byte[4 + n2 * size];
        LittleEndianConversions.I2OSP(n2, result, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            LittleEndianConversions.I2OSP(this.perm[i2], result, 4 + i2 * size, size);
        }
        return result;
    }

    public int[] getVector() {
        return IntUtils.clone(this.perm);
    }

    public Permutation computeInverse() {
        Permutation result = new Permutation(this.perm.length);
        for (int i2 = this.perm.length - 1; i2 >= 0; --i2) {
            result.perm[this.perm[i2]] = i2;
        }
        return result;
    }

    public Permutation rightMultiply(Permutation p2) {
        if (p2.perm.length != this.perm.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        Permutation result = new Permutation(this.perm.length);
        for (int i2 = this.perm.length - 1; i2 >= 0; --i2) {
            result.perm[i2] = this.perm[p2.perm[i2]];
        }
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Permutation)) {
            return false;
        }
        Permutation otherPerm = (Permutation)other;
        return IntUtils.equals(this.perm, otherPerm.perm);
    }

    public String toString() {
        String result = "[" + this.perm[0];
        for (int i2 = 1; i2 < this.perm.length; ++i2) {
            result = result + ", " + this.perm[i2];
        }
        result = result + "]";
        return result;
    }

    public int hashCode() {
        return this.perm.hashCode();
    }

    private boolean isPermutation(int[] perm) {
        int n2 = perm.length;
        boolean[] onlyOnce = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (perm[i2] < 0 || perm[i2] >= n2 || onlyOnce[perm[i2]]) {
                return false;
            }
            onlyOnce[perm[i2]] = true;
        }
        return true;
    }
}

