/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1SequenceParser;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.BERSequence;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DLSequence;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ASN1Sequence
extends ASN1Primitive {
    protected Vector seq = new Vector();

    public static ASN1Sequence getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1Sequence) {
            return (ASN1Sequence)obj;
        }
        if (obj instanceof ASN1SequenceParser) {
            return ASN1Sequence.getInstance(((ASN1SequenceParser)obj).toASN1Primitive());
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1Sequence.getInstance(ASN1Sequence.fromByteArray((byte[])obj));
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + e2.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1Sequence) {
            return (ASN1Sequence)primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return ASN1Sequence.getInstance(obj.getObject().toASN1Primitive());
        }
        if (obj.isExplicit()) {
            if (obj instanceof BERTaggedObject) {
                return new BERSequence(obj.getObject());
            }
            return new DLSequence(obj.getObject());
        }
        if (obj.getObject() instanceof ASN1Sequence) {
            return (ASN1Sequence)obj.getObject();
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    protected ASN1Sequence() {
    }

    protected ASN1Sequence(ASN1Encodable obj) {
        this.seq.addElement(obj);
    }

    protected ASN1Sequence(ASN1EncodableVector v2) {
        for (int i2 = 0; i2 != v2.size(); ++i2) {
            this.seq.addElement(v2.get(i2));
        }
    }

    protected ASN1Sequence(ASN1Encodable[] array) {
        for (int i2 = 0; i2 != array.length; ++i2) {
            this.seq.addElement(array[i2]);
        }
    }

    public ASN1Encodable[] toArray() {
        ASN1Encodable[] values = new ASN1Encodable[this.size()];
        for (int i2 = 0; i2 != this.size(); ++i2) {
            values[i2] = this.getObjectAt(i2);
        }
        return values;
    }

    public Enumeration getObjects() {
        return this.seq.elements();
    }

    public ASN1SequenceParser parser() {
        final ASN1Sequence outer = this;
        return new ASN1SequenceParser(){
            private final int c;
            private int d;
            {
                this.c = ASN1Sequence.this.size();
            }

            @Override
            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable obj;
                if (this.d == this.c) {
                    return null;
                }
                if ((obj = ASN1Sequence.this.getObjectAt(this.d++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)obj).parser();
                }
                if (obj instanceof ASN1Set) {
                    return ((ASN1Set)obj).parser();
                }
                return obj;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return outer;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return outer;
            }
        };
    }

    public ASN1Encodable getObjectAt(int index) {
        return (ASN1Encodable)this.seq.elementAt(index);
    }

    public int size() {
        return this.seq.size();
    }

    @Override
    public int hashCode() {
        Enumeration e2 = this.getObjects();
        int hashCode = this.size();
        while (e2.hasMoreElements()) {
            ASN1Encodable o2 = this.getNext(e2);
            hashCode *= 17;
            hashCode ^= o2.hashCode();
        }
        return hashCode;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence other = (ASN1Sequence)o2;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            ASN1Primitive o22;
            ASN1Encodable obj1 = this.getNext(s1);
            ASN1Encodable obj2 = this.getNext(s2);
            ASN1Primitive o1 = obj1.toASN1Primitive();
            if (o1 == (o22 = obj2.toASN1Primitive()) || o1.equals(o22)) continue;
            return false;
        }
        return true;
    }

    private ASN1Encodable getNext(Enumeration e2) {
        ASN1Encodable encObj = (ASN1Encodable)e2.nextElement();
        return encObj;
    }

    @Override
    ASN1Primitive toDERObject() {
        DERSequence derSeq = new DERSequence();
        new DERSequence().seq = this.seq;
        return derSeq;
    }

    @Override
    ASN1Primitive toDLObject() {
        DLSequence dlSeq = new DLSequence();
        new DLSequence().seq = this.seq;
        return dlSeq;
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return this.seq.toString();
    }
}

