/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.operator.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OperatorException;
import com.timevale.tgtext.bouncycastle.operator.SymmetricKeyUnwrapper;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JceGenericKey;
import com.timevale.tgtext.bouncycastle.operator.jcajce.a;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class JceSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private a helper = new a(new DefaultJcaJceHelper());
    private SecretKey secretKey;

    public JceSymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        super(algorithmIdentifier);
        this.secretKey = secretKey;
    }

    public JceSymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new a(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceSymmetricKeyUnwrapper setProvider(String providerName) {
        this.helper = new a(new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        try {
            Cipher keyCipher = this.helper.a(this.getAlgorithmIdentifier().getAlgorithm());
            keyCipher.init(4, this.secretKey);
            return new JceGenericKey(encryptedKeyAlgorithm, keyCipher.unwrap(encryptedKey, this.helper.b(encryptedKeyAlgorithm.getAlgorithm()), 3));
        }
        catch (InvalidKeyException e2) {
            throw new OperatorException("key invalid in message.", e2);
        }
        catch (NoSuchAlgorithmException e3) {
            throw new OperatorException("can't find algorithm.", e3);
        }
    }
}

