/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.timevale.tgtext.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DHParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;

public class TlsDHUtils {
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO = BigInteger.valueOf(2L);

    public static byte[] calculateDHBasicAgreement(DHPublicKeyParameters publicKey, DHPrivateKeyParameters privateKey) {
        DHBasicAgreement dhAgree = new DHBasicAgreement();
        dhAgree.init(privateKey);
        BigInteger agreement = dhAgree.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(agreement);
    }

    public static AsymmetricCipherKeyPair generateDHKeyPair(SecureRandom random, DHParameters dhParams) {
        DHBasicKeyPairGenerator dhGen = new DHBasicKeyPairGenerator();
        dhGen.init(new DHKeyGenerationParameters(random, dhParams));
        return dhGen.generateKeyPair();
    }

    public static DHPrivateKeyParameters generateEphemeralClientKeyExchange(SecureRandom random, DHParameters dhParams, OutputStream os) throws IOException {
        AsymmetricCipherKeyPair dhAgreeClientKeyPair = TlsDHUtils.generateDHKeyPair(random, dhParams);
        DHPrivateKeyParameters dhAgreeClientPrivateKey = (DHPrivateKeyParameters)dhAgreeClientKeyPair.getPrivate();
        BigInteger Yc = ((DHPublicKeyParameters)dhAgreeClientKeyPair.getPublic()).getY();
        byte[] keData = BigIntegers.asUnsignedByteArray(Yc);
        TlsUtils.writeOpaque16(keData, os);
        return dhAgreeClientPrivateKey;
    }

    public static DHPublicKeyParameters validateDHPublicKey(DHPublicKeyParameters key) throws IOException {
        BigInteger Y = key.getY();
        DHParameters params = key.getParameters();
        BigInteger p2 = params.getP();
        BigInteger g2 = params.getG();
        if (!p2.isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        if (g2.compareTo(TWO) < 0 || g2.compareTo(p2.subtract(TWO)) > 0) {
            throw new TlsFatalAlert(47);
        }
        if (Y.compareTo(TWO) < 0 || Y.compareTo(p2.subtract(ONE)) > 0) {
            throw new TlsFatalAlert(47);
        }
        return key;
    }
}

