/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime.validator;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.cms.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSAttributes;
import com.timevale.tgtext.bouncycastle.asn1.cms.Time;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.ExtendedKeyUsage;
import com.timevale.tgtext.bouncycastle.asn1.x509.KeyPurposeId;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import com.timevale.tgtext.bouncycastle.i18n.ErrorBundle;
import com.timevale.tgtext.bouncycastle.i18n.filter.TrustedInput;
import com.timevale.tgtext.bouncycastle.i18n.filter.UntrustedInput;
import com.timevale.tgtext.bouncycastle.jce.PrincipalUtil;
import com.timevale.tgtext.bouncycastle.jce.X509Principal;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMESigned;
import com.timevale.tgtext.bouncycastle.mail.smime.validator.SignedMailValidatorException;
import com.timevale.tgtext.bouncycastle.util.Integers;
import com.timevale.tgtext.bouncycastle.x509.CertPathReviewerException;
import com.timevale.tgtext.bouncycastle.x509.PKIXCertPathReviewer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.mail.a;
import javax.mail.internet.f;
import javax.mail.internet.k;
import javax.mail.internet.l;
import javax.mail.q;
import javax.mail.v;

public class SignedMailValidator {
    private static final String RESOURCE_NAME = "com.timevale.tgtext.bouncycastle.mail.smime.validator.SignedMailValidatorMessages";
    private static final Class DEFAULT_CERT_PATH_REVIEWER = PKIXCertPathReviewer.class;
    private static final String EXT_KEY_USAGE = X509Extensions.ExtendedKeyUsage.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final int shortKeyLength = 512;
    private static final long THIRTY_YEARS_IN_MILLI_SEC = 946728000000L;
    private static final JcaX509CertSelectorConverter selectorConverter = new JcaX509CertSelectorConverter();
    private CertStore certs;
    private SignerInformationStore signers;
    private Map results;
    private String[] fromAddresses;
    private Class certPathReviewerClass;

    public SignedMailValidator(k k2, PKIXParameters pKIXParameters) throws SignedMailValidatorException {
        this(k2, pKIXParameters, DEFAULT_CERT_PATH_REVIEWER);
    }

    public SignedMailValidator(k k2, PKIXParameters pKIXParameters, Class clazz) throws SignedMailValidatorException {
        this.certPathReviewerClass = clazz;
        boolean bl2 = DEFAULT_CERT_PATH_REVIEWER.isAssignableFrom(clazz);
        if (!bl2) {
            throw new IllegalArgumentException("certPathReviewerClass is not a subclass of " + DEFAULT_CERT_PATH_REVIEWER.getName());
        }
        try {
            SMIMESigned sMIMESigned;
            a[] aArray;
            if (k2.isMimeType("multipart/signed")) {
                aArray = (a[])k2.getContent();
                sMIMESigned = new SMIMESigned((l)aArray);
            } else if (k2.isMimeType("application/pkcs7-mime") || k2.isMimeType("application/x-pkcs7-mime")) {
                sMIMESigned = new SMIMESigned((v)k2);
            } else {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.noSignedMessage");
                throw new SignedMailValidatorException(errorBundle);
            }
            this.certs = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            this.signers = sMIMESigned.getSignerInfos();
            aArray = k2.i();
            f f2 = null;
            try {
                if (k2.getHeader("Sender") != null) {
                    f2 = new f(k2.getHeader("Sender")[0]);
                }
            }
            catch (q q2) {}
            this.fromAddresses = new String[aArray.length + (f2 != null ? 1 : 0)];
            for (int i2 = 0; i2 < aArray.length; ++i2) {
                f f3 = (f)aArray[i2];
                this.fromAddresses[i2] = f3.d();
            }
            if (f2 != null) {
                this.fromAddresses[aArray.length] = f2.d();
            }
            this.results = new HashMap();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof SignedMailValidatorException) {
                throw (SignedMailValidatorException)exception2;
            }
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.exceptionReadingMessage", new Object[]{exception2.getMessage(), exception2, exception2.getClass().getName()});
            throw new SignedMailValidatorException(errorBundle, (Throwable)exception2);
        }
        this.validateSignatures(pKIXParameters);
    }

    protected void validateSignatures(PKIXParameters pKIXParameters) {
        PKIXParameters pKIXParameters2 = (PKIXParameters)pKIXParameters.clone();
        pKIXParameters2.addCertStore(this.certs);
        Collection collection = this.signers.getSigners();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<ErrorBundle> arrayList2 = new ArrayList<ErrorBundle>();
            SignerInformation signerInformation = (SignerInformation)iterator.next();
            X509Certificate x509Certificate = null;
            try {
                object2 = SignedMailValidator.findCerts(pKIXParameters2.getCertStores(), selectorConverter.getCertSelector(signerInformation.getSID()));
                object = object2.iterator();
                if (object.hasNext()) {
                    x509Certificate = (X509Certificate)object.next();
                }
            }
            catch (CertStoreException certStoreException) {
                object = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.exceptionRetrievingSignerCert", new Object[]{certStoreException.getMessage(), certStoreException, certStoreException.getClass().getName()});
                arrayList.add(object);
            }
            if (x509Certificate != null) {
                Object object3;
                Object object4;
                Object object5;
                boolean bl2 = false;
                try {
                    bl2 = signerInformation.verify(x509Certificate.getPublicKey(), "BC");
                    if (!bl2) {
                        object = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.signatureNotVerified");
                        arrayList.add(object);
                    }
                }
                catch (Exception exception) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.exceptionVerifyingSignature", new Object[]{exception.getMessage(), exception, exception.getClass().getName()});
                    arrayList.add(object5);
                }
                this.checkSignerCert(x509Certificate, arrayList, arrayList2);
                object = signerInformation.getSignedAttributes();
                if (object != null && (object5 = ((AttributeTable)object).get(PKCSObjectIdentifiers.id_aa_receiptRequest)) != null) {
                    object4 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.signedReceiptRequest");
                    arrayList2.add((ErrorBundle)object4);
                }
                if ((object5 = SignedMailValidator.getSignatureTime(signerInformation)) == null) {
                    object4 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.noSigningTime");
                    arrayList.add(object4);
                    object5 = new Date();
                } else {
                    try {
                        x509Certificate.checkValidity((Date)object5);
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        object3 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.certExpired", new Object[]{new TrustedInput(object5), new TrustedInput(x509Certificate.getNotAfter())});
                        arrayList.add(object3);
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        object3 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.certNotYetValid", new Object[]{new TrustedInput(object5), new TrustedInput(x509Certificate.getNotBefore())});
                        arrayList.add(object3);
                    }
                }
                pKIXParameters2.setDate((Date)object5);
                try {
                    PKIXCertPathReviewer pKIXCertPathReviewer;
                    ArrayList<CertStore> arrayList3 = new ArrayList<CertStore>();
                    arrayList3.add(this.certs);
                    Object[] objectArray = SignedMailValidator.createCertPath(x509Certificate, pKIXParameters2.getTrustAnchors(), pKIXParameters.getCertStores(), arrayList3);
                    object4 = (CertPath)objectArray[0];
                    object3 = (List)objectArray[1];
                    try {
                        pKIXCertPathReviewer = (PKIXCertPathReviewer)this.certPathReviewerClass.newInstance();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IllegalArgumentException("Cannot instantiate object of type " + this.certPathReviewerClass.getName() + ": " + illegalAccessException.getMessage());
                    }
                    catch (InstantiationException instantiationException) {
                        throw new IllegalArgumentException("Cannot instantiate object of type " + this.certPathReviewerClass.getName() + ": " + instantiationException.getMessage());
                    }
                    pKIXCertPathReviewer.init((CertPath)object4, pKIXParameters2);
                    if (!pKIXCertPathReviewer.isValidCertPath()) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.certPathInvalid");
                        arrayList.add(errorBundle);
                    }
                    this.results.put(signerInformation, new ValidationResult(pKIXCertPathReviewer, bl2, arrayList, arrayList2, (List)object3));
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object3 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.exceptionCreateCertPath", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    arrayList.add(object3);
                    this.results.put(signerInformation, new ValidationResult(null, bl2, arrayList, arrayList2, null));
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    arrayList.add(certPathReviewerException.getErrorMessage());
                    this.results.put(signerInformation, new ValidationResult(null, bl2, arrayList, arrayList2, null));
                }
                continue;
            }
            object2 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.noSignerCert");
            arrayList.add(object2);
            this.results.put(signerInformation, new ValidationResult(null, false, arrayList, arrayList2, null));
        }
    }

    public static Set getEmailAddresses(X509Certificate x509Certificate) throws IOException, CertificateEncodingException {
        byte[] byArray;
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        X509Principal x509Principal = PrincipalUtil.getSubjectX509Principal(x509Certificate);
        Vector vector = x509Principal.getOIDs();
        Vector vector2 = x509Principal.getValues();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (!vector.get(i2).equals(X509Principal.EmailAddress)) continue;
            object = ((String)vector2.get(i2)).toLowerCase();
            hashSet.add(object);
            break;
        }
        if ((byArray = x509Certificate.getExtensionValue(SUBJECT_ALTERNATIVE_NAME)) != null) {
            object = ASN1Sequence.getInstance(SignedMailValidator.getObject(byArray));
            for (int i3 = 0; i3 < ((ASN1Sequence)object).size(); ++i3) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)((ASN1Sequence)object).getObjectAt(i3);
                if (aSN1TaggedObject.getTagNo() != 1) continue;
                String string = DERIA5String.getInstance(aSN1TaggedObject, false).getString().toLowerCase();
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private static ASN1Primitive getObject(byte[] byArray) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
        aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
        return aSN1InputStream.readObject();
    }

    protected void checkSignerCert(X509Certificate x509Certificate, List list, List list2) {
        Object object;
        Object object2;
        Object object3;
        long l2;
        PublicKey publicKey = x509Certificate.getPublicKey();
        int n2 = -1;
        if (publicKey instanceof RSAPublicKey) {
            n2 = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            n2 = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (n2 != -1 && n2 <= 512) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.shortSigningKey", new Object[]{Integers.valueOf(n2)});
            list2.add(errorBundle);
        }
        if ((l2 = x509Certificate.getNotAfter().getTime() - x509Certificate.getNotBefore().getTime()) > 946728000000L) {
            object3 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.longValidity", new Object[]{new TrustedInput(x509Certificate.getNotBefore()), new TrustedInput(x509Certificate.getNotAfter())});
            list2.add(object3);
        }
        if ((object3 = x509Certificate.getKeyUsage()) != null && !object3[0] && !object3[1]) {
            object2 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.signingNotPermitted");
            list.add(object2);
        }
        try {
            object2 = x509Certificate.getExtensionValue(EXT_KEY_USAGE);
            if (object2 != null && !((ExtendedKeyUsage)(object = ExtendedKeyUsage.getInstance(SignedMailValidator.getObject((byte[])object2)))).hasKeyPurposeId(KeyPurposeId.anyExtendedKeyUsage) && !((ExtendedKeyUsage)object).hasKeyPurposeId(KeyPurposeId.id_kp_emailProtection)) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.extKeyUsageNotPermitted");
                list.add(errorBundle);
            }
        }
        catch (Exception exception) {
            object = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.extKeyUsageError", new Object[]{exception.getMessage(), exception, exception.getClass().getName()});
            list.add(object);
        }
        try {
            Set set = SignedMailValidator.getEmailAddresses(x509Certificate);
            object2 = set;
            if (!set.isEmpty()) {
                boolean bl2 = false;
                for (int i2 = 0; i2 < this.fromAddresses.length; ++i2) {
                    if (!object2.contains(this.fromAddresses[i2].toLowerCase())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.emailFromCertMismatch", new Object[]{new UntrustedInput(SignedMailValidator.addressesToString(this.fromAddresses)), new UntrustedInput(object2)});
                    list.add(errorBundle);
                }
                return;
            }
            object = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.noEmailInCert");
            list.add(object);
        }
        catch (Exception exception) {
            object = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.certGetEmailError", new Object[]{exception.getMessage(), exception, exception.getClass().getName()});
            list.add(object);
        }
    }

    static String addressesToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i2 = 0; i2 != objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(objectArray[i2]));
        }
        return stringBuffer.append(']').toString();
    }

    public static Date getSignatureTime(SignerInformation signerInformation) {
        Attribute attribute;
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        Date date = null;
        if (attributeTable != null && (attribute = attributeTable.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance(attribute.getAttrValues().getObjectAt(0).toASN1Primitive());
            date = time.getDate();
        }
        return date;
    }

    private static List findCerts(List list, X509CertSelector x509CertSelector) throws CertStoreException {
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
        for (CertStore certStore : list) {
            Collection<? extends Certificate> collection = certStore.getCertificates(x509CertSelector);
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    private static X509Certificate findNextCert(List list, X509CertSelector x509CertSelector, Set set) throws CertStoreException {
        Iterator iterator = SignedMailValidator.findCerts(list, x509CertSelector).iterator();
        boolean bl2 = false;
        X509Certificate x509Certificate = null;
        while (iterator.hasNext()) {
            x509Certificate = (X509Certificate)iterator.next();
            if (set.contains(x509Certificate)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            return x509Certificate;
        }
        return null;
    }

    public static CertPath createCertPath(X509Certificate x509Certificate, Set set, List list) throws GeneralSecurityException {
        Object[] objectArray = SignedMailValidator.createCertPath(x509Certificate, set, list, null);
        return (CertPath)objectArray[0];
    }

    public static Object[] createCertPath(X509Certificate x509Certificate, Set set, List list, List list2) throws GeneralSecurityException {
        Object object;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        X509Certificate x509Certificate2 = x509Certificate;
        linkedHashSet.add(x509Certificate2);
        arrayList.add(new Boolean(true));
        boolean bl2 = false;
        Object object2 = null;
        while (x509Certificate2 != null && !bl2) {
            Object object3;
            Object object42;
            for (Object object42 : set) {
                object3 = ((TrustAnchor)object42).getTrustedCert();
                if (object3 != null) {
                    if (!((X509Certificate)object3).getSubjectX500Principal().equals(x509Certificate2.getIssuerX500Principal())) continue;
                    try {
                        x509Certificate2.verify(((Certificate)object3).getPublicKey(), "BC");
                        bl2 = true;
                        object2 = object3;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!((TrustAnchor)object42).getCAName().equals(x509Certificate2.getIssuerX500Principal().getName())) continue;
                try {
                    x509Certificate2.verify(((TrustAnchor)object42).getCAPublicKey(), "BC");
                    bl2 = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (bl2) continue;
            object42 = new X509CertSelector();
            try {
                ((X509CertSelector)object42).setSubject(x509Certificate2.getIssuerX500Principal().getEncoded());
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException.toString());
            }
            byte[] byArray = x509Certificate2.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
            object3 = byArray;
            if (byArray != null) {
                try {
                    AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(SignedMailValidator.getObject((byte[])object3));
                    if (authorityKeyIdentifier.getKeyIdentifier() != null) {
                        ((X509CertSelector)object42).setSubjectKeyIdentifier(new DEROctetString(authorityKeyIdentifier.getKeyIdentifier()).getEncoded("DER"));
                    }
                }
                catch (IOException iOException) {}
            }
            boolean bl3 = false;
            x509Certificate2 = SignedMailValidator.findNextCert(list, (X509CertSelector)object42, linkedHashSet);
            if (x509Certificate2 == null && list2 != null) {
                bl3 = true;
                x509Certificate2 = SignedMailValidator.findNextCert(list2, (X509CertSelector)object42, linkedHashSet);
            }
            if (x509Certificate2 == null) continue;
            linkedHashSet.add(x509Certificate2);
            arrayList.add(new Boolean(bl3));
        }
        if (bl2) {
            if (object2 != null && ((X509Certificate)object2).getSubjectX500Principal().equals(((X509Certificate)object2).getIssuerX500Principal())) {
                linkedHashSet.add(object2);
                arrayList.add(new Boolean(false));
            } else {
                object = new X509CertSelector();
                try {
                    ((X509CertSelector)object).setSubject(x509Certificate2.getIssuerX500Principal().getEncoded());
                    ((X509CertSelector)object).setIssuer(x509Certificate2.getIssuerX500Principal().getEncoded());
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException.toString());
                }
                boolean bl4 = false;
                object2 = SignedMailValidator.findNextCert(list, (X509CertSelector)object, linkedHashSet);
                if (object2 == null && list2 != null) {
                    bl4 = true;
                    object2 = SignedMailValidator.findNextCert(list2, (X509CertSelector)object, linkedHashSet);
                }
                if (object2 != null) {
                    try {
                        x509Certificate2.verify(((Certificate)object2).getPublicKey(), "BC");
                        linkedHashSet.add(object2);
                        arrayList.add(new Boolean(bl4));
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                }
            }
        }
        object = CertificateFactory.getInstance("X.509", "BC").generateCertPath(new ArrayList(linkedHashSet));
        return new Object[]{object, arrayList};
    }

    public CertStore getCertsAndCRLs() {
        return this.certs;
    }

    public SignerInformationStore getSignerInformationStore() {
        return this.signers;
    }

    public ValidationResult getValidationResult(SignerInformation signerInformation) throws SignedMailValidatorException {
        if (this.signers.getSigners(signerInformation.getSID()).isEmpty()) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.wrongSigner");
            throw new SignedMailValidatorException(errorBundle);
        }
        return (ValidationResult)this.results.get(signerInformation);
    }

    public class ValidationResult {
        private PKIXCertPathReviewer review;
        private List errors;
        private List notifications;
        private List userProvidedCerts;
        private boolean signVerified;

        ValidationResult(PKIXCertPathReviewer pKIXCertPathReviewer, boolean bl2, List list, List list2, List list3) {
            this.review = pKIXCertPathReviewer;
            this.errors = list;
            this.notifications = list2;
            this.signVerified = bl2;
            this.userProvidedCerts = list3;
        }

        public List getErrors() {
            return this.errors;
        }

        public List getNotifications() {
            return this.notifications;
        }

        public PKIXCertPathReviewer getCertPathReview() {
            return this.review;
        }

        public CertPath getCertPath() {
            if (this.review != null) {
                return this.review.getCertPath();
            }
            return null;
        }

        public List getUserProvidedCerts() {
            return this.userProvidedCerts;
        }

        public boolean isVerifiedSignature() {
            return this.signVerified;
        }

        public boolean isValidSignature() {
            if (this.review != null) {
                return this.signVerified && this.review.isValidCertPath() && this.errors.isEmpty();
            }
            return false;
        }
    }
}

