/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ecgost;

import com.timevale.tgtext.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.ECDomainParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ec.EC5Util;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PrivateKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import com.timevale.tgtext.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.timevale.tgtext.bouncycastle.jce.spec.ECParameterSpec;
import com.timevale.tgtext.bouncycastle.math.ec.ECCurve;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    Object ecParams = null;
    ECKeyPairGenerator engine = new ECKeyPairGenerator();
    String algorithm = "ECGOST3410";
    ECKeyGenerationParameters param;
    int strength = 239;
    SecureRandom random = null;
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("ECGOST3410");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
        if (this.ecParams != null) {
            try {
                this.initialize((ECGenParameterSpec)this.ecParams, random);
                return;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException("key size not configurable.");
            }
        }
        throw new InvalidParameterException("unknown key size.");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof ECParameterSpec) {
            ECParameterSpec p2 = (ECParameterSpec)params;
            this.ecParams = params;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(p2.getCurve(), p2.getG(), p2.getN()), random);
            this.engine.init(this.param);
            this.initialised = true;
            return;
        }
        if (params instanceof java.security.spec.ECParameterSpec) {
            java.security.spec.ECParameterSpec p3 = (java.security.spec.ECParameterSpec)params;
            this.ecParams = params;
            ECCurve curve = EC5Util.convertCurve(p3.getCurve());
            ECPoint g2 = EC5Util.convertPoint(curve, p3.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g2, p3.getOrder(), BigInteger.valueOf(p3.getCofactor())), random);
            this.engine.init(this.param);
            this.initialised = true;
            return;
        }
        if (params instanceof ECGenParameterSpec || params instanceof ECNamedCurveGenParameterSpec) {
            String curveName = params instanceof ECGenParameterSpec ? ((ECGenParameterSpec)params).getName() : ((ECNamedCurveGenParameterSpec)params).getName();
            ECDomainParameters ecP = ECGOST3410NamedCurves.getByName(curveName);
            if (ecP == null) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
            }
            this.ecParams = new ECNamedCurveSpec(curveName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            java.security.spec.ECParameterSpec p4 = (java.security.spec.ECParameterSpec)this.ecParams;
            ECCurve curve = EC5Util.convertCurve(p4.getCurve());
            ECPoint g3 = EC5Util.convertPoint(curve, p4.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g3, p4.getOrder(), BigInteger.valueOf(p4.getCofactor())), random);
            this.engine.init(this.param);
            this.initialised = true;
            return;
        }
        if (params == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() != null) {
            ECParameterSpec p5 = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            this.ecParams = params;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(p5.getCurve(), p5.getG(), p5.getN()), random);
            this.engine.init(this.param);
            this.initialised = true;
            return;
        }
        if (params == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() == null) {
            throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
        }
        throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec: " + params.getClass().getName());
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            throw new IllegalStateException("EC Key Pair Generator not initialised");
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
        ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
        if (this.ecParams instanceof ECParameterSpec) {
            ECParameterSpec p2 = (ECParameterSpec)this.ecParams;
            BCECGOST3410PublicKey pubKey = new BCECGOST3410PublicKey(this.algorithm, pub, p2);
            return new KeyPair(pubKey, new BCECGOST3410PrivateKey(this.algorithm, priv, pubKey, p2));
        }
        if (this.ecParams == null) {
            return new KeyPair(new BCECGOST3410PublicKey(this.algorithm, pub), new BCECGOST3410PrivateKey(this.algorithm, priv));
        }
        java.security.spec.ECParameterSpec p3 = (java.security.spec.ECParameterSpec)this.ecParams;
        BCECGOST3410PublicKey pubKey = new BCECGOST3410PublicKey(this.algorithm, pub, p3);
        return new KeyPair(pubKey, new BCECGOST3410PrivateKey(this.algorithm, priv, pubKey, p3));
    }
}

