/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.i;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class DERInteger
extends ASN1Primitive {
    byte[] bytes;

    public static ASN1Integer getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Integer) {
            return (ASN1Integer)obj;
        }
        if (obj instanceof DERInteger) {
            return new ASN1Integer(((DERInteger)obj).getValue());
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1Integer)DERInteger.fromByteArray((byte[])obj);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e2.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Integer getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERInteger) {
            return DERInteger.getInstance(o2);
        }
        return new ASN1Integer(ASN1OctetString.getInstance(obj.getObject()).getOctets());
    }

    public DERInteger(long value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    public DERInteger(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public DERInteger(byte[] bytes) {
        this.bytes = bytes;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + i.a(this.bytes.length) + this.bytes.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(2, this.bytes);
    }

    @Override
    public int hashCode() {
        int value = 0;
        for (int i2 = 0; i2 != this.bytes.length; ++i2) {
            value ^= (this.bytes[i2] & 0xFF) << i2 % 4;
        }
        return value;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERInteger)) {
            return false;
        }
        DERInteger other = (DERInteger)o2;
        return Arrays.areEqual(this.bytes, other.bytes);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

