/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.engines.a;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.timevale.tgtext.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private a core = new a();
    private RSAKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.core.a(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
            return;
        }
        this.key = (RSAKeyParameters)param;
        this.random = new SecureRandom();
    }

    @Override
    public int getInputBlockSize() {
        return this.core.a();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.b();
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        BigInteger result;
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger input = this.core.a(in, inOff, inLen);
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters k2 = (RSAPrivateCrtKeyParameters)this.key;
            BigInteger e2 = k2.getPublicExponent();
            if (e2 != null) {
                BigInteger m2 = k2.getModulus();
                BigInteger r2 = BigIntegers.createRandomInRange(ONE, m2.subtract(ONE), this.random);
                BigInteger blindedInput = r2.modPow(e2, m2).multiply(input).mod(m2);
                BigInteger blindedResult = this.core.b(blindedInput);
                BigInteger rInv = r2.modInverse(m2);
                result = blindedResult.multiply(rInv).mod(m2);
            } else {
                result = this.core.b(input);
            }
        } else {
            result = this.core.b(input);
        }
        return this.core.a(result);
    }
}

