/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.CertificatePair;
import com.timevale.tgtext.bouncycastle.jce.provider.X509CertificateObject;
import com.timevale.tgtext.bouncycastle.x509.a;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;

public class X509CertificatePair {
    private X509Certificate forward;
    private X509Certificate reverse;

    public X509CertificatePair(X509Certificate forward, X509Certificate reverse) {
        this.forward = forward;
        this.reverse = reverse;
    }

    public X509CertificatePair(CertificatePair pair) throws CertificateParsingException {
        if (pair.getForward() != null) {
            this.forward = new X509CertificateObject(pair.getForward());
        }
        if (pair.getReverse() != null) {
            this.reverse = new X509CertificateObject(pair.getReverse());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        Certificate f2 = null;
        Certificate r2 = null;
        try {
            if (this.forward != null && (f2 = Certificate.getInstance(new ASN1InputStream(this.forward.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for forward");
            }
            if (this.reverse != null && (r2 = Certificate.getInstance(new ASN1InputStream(this.reverse.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for reverse");
            }
            return new CertificatePair(f2, r2).getEncoded("DER");
        }
        catch (IllegalArgumentException e2) {
            throw new a(e2.toString(), e2);
        }
        catch (IOException e3) {
            throw new a(e3.toString(), e3);
        }
    }

    public X509Certificate getForward() {
        return this.forward;
    }

    public X509Certificate getReverse() {
        return this.reverse;
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof X509CertificatePair)) {
            return false;
        }
        X509CertificatePair pair = (X509CertificatePair)o2;
        boolean equalReverse = true;
        boolean equalForward = true;
        if (this.forward != null) {
            equalForward = this.forward.equals(pair.forward);
        } else if (pair.forward != null) {
            equalForward = false;
        }
        if (this.reverse != null) {
            equalReverse = this.reverse.equals(pair.reverse);
        } else if (pair.reverse != null) {
            equalReverse = false;
        }
        return equalForward && equalReverse;
    }

    public int hashCode() {
        int hash = -1;
        if (this.forward != null) {
            hash = 0xFFFFFFFF ^ this.forward.hashCode();
        }
        if (this.reverse != null) {
            hash *= 17;
            hash ^= this.reverse.hashCode();
        }
        return hash;
    }
}

