/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.digests;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.ExtendedDigest;
import com.timevale.tgtext.bouncycastle.crypto.engines.GOST28147Engine;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithSBox;
import com.timevale.tgtext.bouncycastle.crypto.util.Pack;
import com.timevale.tgtext.bouncycastle.util.Arrays;

public class GOST3411Digest
implements ExtendedDigest {
    private static final int DIGEST_LENGTH = 32;
    private byte[] H = new byte[32];
    private byte[] L = new byte[32];
    private byte[] M = new byte[32];
    private byte[] Sum = new byte[32];
    private byte[][] C = new byte[4][32];
    private byte[] xBuf = new byte[32];
    private int xBufOff;
    private long byteCount;
    private BlockCipher cipher = new GOST28147Engine();
    private byte[] sBox;
    private byte[] K = new byte[32];
    byte[] a = new byte[8];
    short[] wS = new short[16];
    short[] w_S = new short[16];
    byte[] S = new byte[32];
    byte[] U = new byte[32];
    byte[] V = new byte[32];
    byte[] W = new byte[32];
    private static final byte[] C2 = new byte[]{0, -1, 0, -1, 0, -1, 0, -1, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, -1, 0, -1, 0, 0, -1, -1, 0, 0, 0, -1, -1, 0, -1};

    public GOST3411Digest() {
        this.sBox = GOST28147Engine.getSBox("D-A");
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
    }

    public GOST3411Digest(byte[] sBoxParam) {
        this.sBox = Arrays.clone(sBoxParam);
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
    }

    public GOST3411Digest(GOST3411Digest t2) {
        this.sBox = t2.sBox;
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
        System.arraycopy(t2.H, 0, this.H, 0, t2.H.length);
        System.arraycopy(t2.L, 0, this.L, 0, t2.L.length);
        System.arraycopy(t2.M, 0, this.M, 0, t2.M.length);
        System.arraycopy(t2.Sum, 0, this.Sum, 0, t2.Sum.length);
        System.arraycopy(t2.C[1], 0, this.C[1], 0, t2.C[1].length);
        System.arraycopy(t2.C[2], 0, this.C[2], 0, t2.C[2].length);
        System.arraycopy(t2.C[3], 0, this.C[3], 0, t2.C[3].length);
        System.arraycopy(t2.xBuf, 0, this.xBuf, 0, t2.xBuf.length);
        this.xBufOff = t2.xBufOff;
        this.byteCount = t2.byteCount;
    }

    @Override
    public String getAlgorithmName() {
        return "GOST3411";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.sumByteArray(this.xBuf);
            this.processBlock(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        while (this.xBufOff != 0 && len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
        while (len > this.xBuf.length) {
            System.arraycopy(in, inOff, this.xBuf, 0, this.xBuf.length);
            this.sumByteArray(this.xBuf);
            this.processBlock(this.xBuf, 0);
            inOff += this.xBuf.length;
            len -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    private byte[] P(byte[] in) {
        for (int k2 = 0; k2 < 8; ++k2) {
            this.K[4 * k2] = in[k2];
            this.K[1 + 4 * k2] = in[k2 + 8];
            this.K[2 + 4 * k2] = in[k2 + 16];
            this.K[3 + 4 * k2] = in[k2 + 24];
        }
        return this.K;
    }

    private byte[] A(byte[] in) {
        for (int j2 = 0; j2 < 8; ++j2) {
            this.a[j2] = (byte)(in[j2] ^ in[j2 + 8]);
        }
        System.arraycopy(in, 8, in, 0, 24);
        System.arraycopy(this.a, 0, in, 24, 8);
        return in;
    }

    private void E(byte[] key, byte[] s2, int sOff, byte[] in, int inOff) {
        this.cipher.init(true, new KeyParameter(key));
        this.cipher.processBlock(in, inOff, s2, sOff);
    }

    private void fw(byte[] in) {
        this.cpyBytesToShort(in, this.wS);
        this.w_S[15] = (short)(this.wS[0] ^ this.wS[1] ^ this.wS[2] ^ this.wS[3] ^ this.wS[12] ^ this.wS[15]);
        System.arraycopy(this.wS, 1, this.w_S, 0, 15);
        this.cpyShortToBytes(this.w_S, in);
    }

    protected void processBlock(byte[] in, int inOff) {
        int n2;
        System.arraycopy(in, inOff, this.M, 0, 32);
        System.arraycopy(this.H, 0, this.U, 0, 32);
        System.arraycopy(this.M, 0, this.V, 0, 32);
        for (int j2 = 0; j2 < 32; ++j2) {
            this.W[j2] = (byte)(this.U[j2] ^ this.V[j2]);
        }
        this.E(this.P(this.W), this.S, 0, this.H, 0);
        for (int i2 = 1; i2 < 4; ++i2) {
            int j3;
            byte[] tmpA = this.A(this.U);
            for (j3 = 0; j3 < 32; ++j3) {
                this.U[j3] = (byte)(tmpA[j3] ^ this.C[i2][j3]);
            }
            this.V = this.A(this.A(this.V));
            for (j3 = 0; j3 < 32; ++j3) {
                this.W[j3] = (byte)(this.U[j3] ^ this.V[j3]);
            }
            this.E(this.P(this.W), this.S, i2 << 3, this.H, i2 << 3);
        }
        for (n2 = 0; n2 < 12; ++n2) {
            this.fw(this.S);
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.S[n2] = (byte)(this.S[n2] ^ this.M[n2]);
        }
        this.fw(this.S);
        for (n2 = 0; n2 < 32; ++n2) {
            this.S[n2] = (byte)(this.H[n2] ^ this.S[n2]);
        }
        for (n2 = 0; n2 < 61; ++n2) {
            this.fw(this.S);
        }
        System.arraycopy(this.S, 0, this.H, 0, this.H.length);
    }

    private void finish() {
        Pack.longToLittleEndian(this.byteCount << 3, this.L, 0);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processBlock(this.L, 0);
        this.processBlock(this.Sum, 0);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        System.arraycopy(this.H, 0, out, outOff, this.H.length);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        int i2;
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (i2 = 0; i2 < this.H.length; ++i2) {
            this.H[i2] = 0;
        }
        for (i2 = 0; i2 < this.L.length; ++i2) {
            this.L[i2] = 0;
        }
        for (i2 = 0; i2 < this.M.length; ++i2) {
            this.M[i2] = 0;
        }
        for (i2 = 0; i2 < this.C[1].length; ++i2) {
            this.C[1][i2] = 0;
        }
        for (i2 = 0; i2 < this.C[3].length; ++i2) {
            this.C[3][i2] = 0;
        }
        for (i2 = 0; i2 < this.Sum.length; ++i2) {
            this.Sum[i2] = 0;
        }
        for (i2 = 0; i2 < this.xBuf.length; ++i2) {
            this.xBuf[i2] = 0;
        }
        System.arraycopy(C2, 0, this.C[2], 0, C2.length);
    }

    private void sumByteArray(byte[] in) {
        int carry = 0;
        for (int i2 = 0; i2 != this.Sum.length; ++i2) {
            int sum = (this.Sum[i2] & 0xFF) + (in[i2] & 0xFF) + carry;
            this.Sum[i2] = (byte)sum;
            carry = sum >>> 8;
        }
    }

    private void cpyBytesToShort(byte[] S, short[] wS) {
        for (int i2 = 0; i2 < S.length / 2; ++i2) {
            wS[i2] = (short)(S[(i2 << 1) + 1] << 8 & 0xFF00 | S[i2 << 1] & 0xFF);
        }
    }

    private void cpyShortToBytes(short[] wS, byte[] S) {
        for (int i2 = 0; i2 < S.length / 2; ++i2) {
            S[(i2 << 1) + 1] = (byte)(wS[i2] >> 8);
            S[i2 << 1] = (byte)wS[i2];
        }
    }

    @Override
    public int getByteLength() {
        return 32;
    }
}

