/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.selector.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.cert.selector.X509CertificateHolderSelector;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CertSelector;

public class JcaX509CertSelectorConverter {
    protected X509CertSelector doConversion(X500Name issuer, BigInteger serialNumber, byte[] subjectKeyIdentifier) {
        X509CertSelector selector = new X509CertSelector();
        if (issuer != null) {
            try {
                selector.setIssuer(issuer.getEncoded());
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("unable to convert issuer: " + e2.getMessage());
            }
        }
        if (serialNumber != null) {
            selector.setSerialNumber(serialNumber);
        }
        if (subjectKeyIdentifier != null) {
            try {
                selector.setSubjectKeyIdentifier(new DEROctetString(subjectKeyIdentifier).getEncoded());
            }
            catch (IOException e3) {
                throw new IllegalArgumentException("unable to convert issuer: " + e3.getMessage());
            }
        }
        return selector;
    }

    public X509CertSelector getCertSelector(X509CertificateHolderSelector holderSelector) {
        return this.doConversion(holderSelector.getIssuer(), holderSelector.getSerialNumber(), holderSelector.getSubjectKeyIdentifier());
    }
}

