/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;

public class GMSSRootSig {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[] privateKeyOTS;
    private byte[] hash;
    private byte[] sign;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int k;
    private int r;
    private int test;
    private int counter;
    private int ii;
    private long test8;
    private long big8;
    private int steps;
    private int checksum;
    private int height;
    private byte[] seed;

    public GMSSRootSig(Digest digest, byte[][] statByte, int[] statInt) {
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.counter = statInt[0];
        this.test = statInt[1];
        this.ii = statInt[2];
        this.r = statInt[3];
        this.steps = statInt[4];
        this.keysize = statInt[5];
        this.height = statInt[6];
        this.w = statInt[7];
        this.checksum = statInt[8];
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.k = (1 << this.w) - 1;
        int mdsizeBit = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)mdsizeBit / (double)this.w);
        this.privateKeyOTS = statByte[0];
        this.seed = statByte[1];
        this.hash = statByte[2];
        this.sign = statByte[3];
        this.test8 = (long)(statByte[4][0] & 0xFF) | (long)(statByte[4][1] & 0xFF) << 8 | (long)(statByte[4][2] & 0xFF) << 16 | (long)(statByte[4][3] & 0xFF) << 24 | (long)(statByte[4][4] & 0xFF) << 32 | (long)(statByte[4][5] & 0xFF) << 40 | (long)(statByte[4][6] & 0xFF) << 48 | (long)(statByte[4][7] & 0xFF) << 56;
        this.big8 = (long)(statByte[4][8] & 0xFF) | (long)(statByte[4][9] & 0xFF) << 8 | (long)(statByte[4][10] & 0xFF) << 16 | (long)(statByte[4][11] & 0xFF) << 24 | (long)(statByte[4][12] & 0xFF) << 32 | (long)(statByte[4][13] & 0xFF) << 40 | (long)(statByte[4][14] & 0xFF) << 48 | (long)(statByte[4][15] & 0xFF) << 56;
    }

    public GMSSRootSig(Digest digest, int w2, int height) {
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.w = w2;
        this.height = height;
        this.k = (1 << w2) - 1;
        int mdsizeBit = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)mdsizeBit / (double)w2);
    }

    public void initSign(byte[] seed0, byte[] message) {
        this.hash = new byte[this.mdsize];
        this.messDigestOTS.update(message, 0, message.length);
        this.hash = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(this.hash, 0);
        byte[] messPart = new byte[this.mdsize];
        System.arraycopy(this.hash, 0, messPart, 0, this.mdsize);
        int sumH = 0;
        int checksumsize = this.getLog((this.messagesize << this.w) + 1);
        if (8 % this.w == 0) {
            int dt2 = 8 / this.w;
            for (int a2 = 0; a2 < this.mdsize; ++a2) {
                for (int b2 = 0; b2 < dt2; ++b2) {
                    sumH += messPart[a2] & this.k;
                    messPart[a2] = (byte)(messPart[a2] >>> this.w);
                }
            }
            int checkPart = this.checksum = (this.messagesize << this.w) - sumH;
            for (int b3 = 0; b3 < checksumsize; b3 += this.w) {
                sumH += checkPart & this.k;
                checkPart >>>= this.w;
            }
        } else if (this.w < 8) {
            int j2;
            long big8;
            int i2;
            int ii = 0;
            int dt3 = this.mdsize / this.w;
            for (i2 = 0; i2 < dt3; ++i2) {
                int j3;
                big8 = 0L;
                for (j3 = 0; j3 < this.w; ++j3) {
                    big8 ^= (long)((messPart[ii] & 0xFF) << (j3 << 3));
                    ++ii;
                }
                for (j3 = 0; j3 < 8; ++j3) {
                    sumH += (int)(big8 & (long)this.k);
                    big8 >>>= this.w;
                }
            }
            dt3 = this.mdsize % this.w;
            big8 = 0L;
            for (j2 = 0; j2 < dt3; ++j2) {
                big8 ^= (long)((messPart[ii] & 0xFF) << (j2 << 3));
                ++ii;
            }
            dt3 <<= 3;
            for (j2 = 0; j2 < dt3; j2 += this.w) {
                sumH += (int)(big8 & (long)this.k);
                big8 >>>= this.w;
            }
            int checkPart = this.checksum = (this.messagesize << this.w) - sumH;
            for (i2 = 0; i2 < checksumsize; i2 += this.w) {
                sumH += checkPart & this.k;
                checkPart >>>= this.w;
            }
        } else if (this.w < 57) {
            int j4;
            int ii;
            long big8;
            int rest;
            int s2;
            int r2 = 0;
            while (r2 <= (this.mdsize << 3) - this.w) {
                s2 = r2 >>> 3;
                rest = r2 % 8;
                int f2 = (r2 += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                for (j4 = s2; j4 < f2; ++j4) {
                    big8 ^= (long)((messPart[j4] & 0xFF) << (ii << 3));
                    ++ii;
                }
                sumH = (int)((long)sumH + ((big8 >>>= rest) & (long)this.k));
            }
            s2 = r2 >>> 3;
            if (s2 < this.mdsize) {
                rest = r2 % 8;
                big8 = 0L;
                ii = 0;
                for (j4 = s2; j4 < this.mdsize; ++j4) {
                    big8 ^= (long)((messPart[j4] & 0xFF) << (ii << 3));
                    ++ii;
                }
                sumH = (int)((long)sumH + ((big8 >>>= rest) & (long)this.k));
            }
            int checkPart = this.checksum = (this.messagesize << this.w) - sumH;
            for (int i3 = 0; i3 < checksumsize; i3 += this.w) {
                sumH += checkPart & this.k;
                checkPart >>>= this.w;
            }
        }
        this.keysize = this.messagesize + (int)Math.ceil((double)checksumsize / (double)this.w);
        this.steps = (int)Math.ceil((double)(this.keysize + sumH) / (double)(1 << this.height));
        this.sign = new byte[this.keysize * this.mdsize];
        this.counter = 0;
        this.test = 0;
        this.ii = 0;
        this.test8 = 0L;
        this.r = 0;
        this.privateKeyOTS = new byte[this.mdsize];
        this.seed = new byte[this.mdsize];
        System.arraycopy(seed0, 0, this.seed, 0, this.mdsize);
    }

    public boolean updateSign() {
        for (int s2 = 0; s2 < this.steps; ++s2) {
            if (this.counter < this.keysize) {
                this.oneStep();
            }
            if (this.counter != this.keysize) continue;
            return true;
        }
        return false;
    }

    public byte[] getSig() {
        return this.sign;
    }

    private void oneStep() {
        if (8 % this.w == 0) {
            if (this.test == 0) {
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
                if (this.ii < this.mdsize) {
                    this.test = this.hash[this.ii] & this.k;
                    this.hash[this.ii] = (byte)(this.hash[this.ii] >>> this.w);
                } else {
                    this.test = this.checksum & this.k;
                    this.checksum >>>= this.w;
                }
            } else if (this.test > 0) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test;
            }
            if (this.test == 0) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                ++this.counter;
                if (this.counter % (8 / this.w) == 0) {
                    ++this.ii;
                    return;
                }
            }
        } else if (this.w < 8) {
            if (this.test == 0) {
                if (this.counter % 8 == 0 && this.ii < this.mdsize) {
                    this.big8 = 0L;
                    if (this.counter < this.mdsize / this.w << 3) {
                        for (int j2 = 0; j2 < this.w; ++j2) {
                            this.big8 ^= (long)((this.hash[this.ii] & 0xFF) << (j2 << 3));
                            ++this.ii;
                        }
                    } else {
                        for (int j3 = 0; j3 < this.mdsize % this.w; ++j3) {
                            this.big8 ^= (long)((this.hash[this.ii] & 0xFF) << (j3 << 3));
                            ++this.ii;
                        }
                    }
                }
                if (this.counter == this.messagesize) {
                    this.big8 = this.checksum;
                }
                this.test = (int)(this.big8 & (long)this.k);
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
            } else if (this.test > 0) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test;
            }
            if (this.test == 0) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                this.big8 >>>= this.w;
                ++this.counter;
                return;
            }
        } else if (this.w < 57) {
            if (this.test8 == 0L) {
                this.big8 = 0L;
                this.ii = 0;
                int rest = this.r % 8;
                int s2 = this.r >>> 3;
                if (s2 < this.mdsize) {
                    int f2;
                    if (this.r <= (this.mdsize << 3) - this.w) {
                        this.r += this.w;
                        f2 = this.r + 7 >>> 3;
                    } else {
                        f2 = this.mdsize;
                        this.r += this.w;
                    }
                    for (int i2 = s2; i2 < f2; ++i2) {
                        this.big8 ^= (long)((this.hash[i2] & 0xFF) << (this.ii << 3));
                        ++this.ii;
                    }
                    this.big8 >>>= rest;
                    this.test8 = this.big8 & (long)this.k;
                } else {
                    this.test8 = this.checksum & this.k;
                    this.checksum >>>= this.w;
                }
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
            } else if (this.test8 > 0L) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test8;
            }
            if (this.test8 == 0L) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                ++this.counter;
            }
        }
    }

    public int getLog(int intValue) {
        int log = 1;
        int i2 = 2;
        while (i2 < intValue) {
            i2 <<= 1;
            ++log;
        }
        return log;
    }

    public byte[][] getStatByte() {
        byte[][] byArray = new byte[5][this.mdsize];
        byte[][] statByte = byArray;
        byArray[0] = this.privateKeyOTS;
        statByte[1] = this.seed;
        statByte[2] = this.hash;
        statByte[3] = this.sign;
        statByte[4] = this.getStatLong();
        return statByte;
    }

    public int[] getStatInt() {
        int[] nArray = new int[9];
        int[] statInt = nArray;
        nArray[0] = this.counter;
        statInt[1] = this.test;
        statInt[2] = this.ii;
        statInt[3] = this.r;
        statInt[4] = this.steps;
        statInt[5] = this.keysize;
        statInt[6] = this.height;
        statInt[7] = this.w;
        statInt[8] = this.checksum;
        return statInt;
    }

    public byte[] getStatLong() {
        byte[] byArray = new byte[16];
        byte[] bytes = byArray;
        byArray[0] = (byte)(this.test8 & 0xFFL);
        bytes[1] = (byte)(this.test8 >> 8 & 0xFFL);
        bytes[2] = (byte)(this.test8 >> 16 & 0xFFL);
        bytes[3] = (byte)(this.test8 >> 24 & 0xFFL);
        bytes[4] = (byte)(this.test8 >> 32 & 0xFFL);
        bytes[5] = (byte)(this.test8 >> 40 & 0xFFL);
        bytes[6] = (byte)(this.test8 >> 48 & 0xFFL);
        bytes[7] = (byte)(this.test8 >> 56 & 0xFFL);
        bytes[8] = (byte)(this.big8 & 0xFFL);
        bytes[9] = (byte)(this.big8 >> 8 & 0xFFL);
        bytes[10] = (byte)(this.big8 >> 16 & 0xFFL);
        bytes[11] = (byte)(this.big8 >> 24 & 0xFFL);
        bytes[12] = (byte)(this.big8 >> 32 & 0xFFL);
        bytes[13] = (byte)(this.big8 >> 40 & 0xFFL);
        bytes[14] = (byte)(this.big8 >> 48 & 0xFFL);
        bytes[15] = (byte)(this.big8 >> 56 & 0xFFL);
        return bytes;
    }

    public String toString() {
        int i2;
        String out = this.big8 + "  ";
        int[] statInt = this.getStatInt();
        byte[][] statByte = this.getStatByte();
        for (i2 = 0; i2 < 9; ++i2) {
            out = out + statInt[i2] + " ";
        }
        for (i2 = 0; i2 < 5; ++i2) {
            out = out + new String(Hex.encode(statByte[i2])) + " ";
        }
        return out;
    }
}

