/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class McElieceCCA2KeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof BCMcElieceCCA2PublicKey) {
            BCMcElieceCCA2PublicKey k2 = (BCMcElieceCCA2PublicKey)key;
            return new McElieceCCA2PublicKeyParameters(k2.getOIDString(), k2.getN(), k2.getT(), k2.getG(), k2.getMcElieceCCA2Parameters());
        }
        throw new InvalidKeyException("can't identify McElieceCCA2 public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof BCMcElieceCCA2PrivateKey) {
            BCMcElieceCCA2PrivateKey k2 = (BCMcElieceCCA2PrivateKey)key;
            return new McElieceCCA2PrivateKeyParameters(k2.getOIDString(), k2.getN(), k2.getK(), k2.getField(), k2.getGoppaPoly(), k2.getP(), k2.getH(), k2.getQInv(), k2.getMcElieceCCA2Parameters());
        }
        throw new InvalidKeyException("can't identify McElieceCCA2 private key.");
    }
}

