/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemGenerationException;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObject;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObjectGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;

public class PKCS8Generator
implements PemObjectGenerator {
    public static final ASN1ObjectIdentifier AES_128_CBC = NISTObjectIdentifiers.id_aes128_CBC;
    public static final ASN1ObjectIdentifier AES_192_CBC = NISTObjectIdentifiers.id_aes192_CBC;
    public static final ASN1ObjectIdentifier AES_256_CBC = NISTObjectIdentifiers.id_aes256_CBC;
    public static final ASN1ObjectIdentifier DES3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC;
    public static final ASN1ObjectIdentifier PBE_SHA1_RC4_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4;
    public static final ASN1ObjectIdentifier PBE_SHA1_RC4_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4;
    public static final ASN1ObjectIdentifier PBE_SHA1_3DES = PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC;
    public static final ASN1ObjectIdentifier PBE_SHA1_2DES = PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC;
    public static final ASN1ObjectIdentifier PBE_SHA1_RC2_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC;
    public static final ASN1ObjectIdentifier PBE_SHA1_RC2_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC;
    private PrivateKeyInfo key;
    private OutputEncryptor outputEncryptor;
    private JceOpenSSLPKCS8EncryptorBuilder encryptorBuilder;

    public PKCS8Generator(PrivateKey key) {
        this.key = PrivateKeyInfo.getInstance(key.getEncoded());
    }

    public PKCS8Generator(PrivateKey key, ASN1ObjectIdentifier algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("cannot find provider: " + provider);
        }
        this.init(key, algorithm, prov);
    }

    public PKCS8Generator(PrivateKey key, ASN1ObjectIdentifier algorithm, Provider provider) throws NoSuchAlgorithmException {
        this.init(key, algorithm, provider);
    }

    public PKCS8Generator(PrivateKeyInfo key, OutputEncryptor outputEncryptor) {
        this.key = key;
        this.outputEncryptor = outputEncryptor;
    }

    private void init(PrivateKey key, ASN1ObjectIdentifier algorithm, Provider provider) throws NoSuchAlgorithmException {
        this.key = PrivateKeyInfo.getInstance(key.getEncoded());
        this.encryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(algorithm);
        this.encryptorBuilder.setProvider(provider);
    }

    public PKCS8Generator setSecureRandom(SecureRandom random) {
        this.encryptorBuilder.setRandom(random);
        return this;
    }

    public PKCS8Generator setPassword(char[] password) {
        this.encryptorBuilder.setPasssword(password);
        return this;
    }

    public PKCS8Generator setIterationCount(int iterationCount) {
        this.encryptorBuilder.setIterationCount(iterationCount);
        return this;
    }

    @Override
    public PemObject generate() throws PemGenerationException {
        try {
            if (this.encryptorBuilder != null) {
                this.outputEncryptor = this.encryptorBuilder.build();
            }
        }
        catch (OperatorCreationException e2) {
            throw new PemGenerationException("unable to create operator: " + e2.getMessage(), e2);
        }
        if (this.outputEncryptor != null) {
            return this.generate(this.key, this.outputEncryptor);
        }
        return this.generate(this.key, null);
    }

    private PemObject generate(PrivateKeyInfo key, OutputEncryptor encryptor) throws PemGenerationException {
        try {
            byte[] keyData = key.getEncoded();
            if (encryptor == null) {
                return new PemObject("PRIVATE KEY", keyData);
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            OutputStream cOut = encryptor.getOutputStream(bOut);
            cOut.write(key.getEncoded());
            cOut.close();
            EncryptedPrivateKeyInfo info = new EncryptedPrivateKeyInfo(encryptor.getAlgorithmIdentifier(), bOut.toByteArray());
            return new PemObject("ENCRYPTED PRIVATE KEY", info.getEncoded());
        }
        catch (IOException e2) {
            throw new PemGenerationException("unable to process encoded key data: " + e2.getMessage(), e2);
        }
    }
}

