/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Boolean;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Enumerated;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Exception;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1StreamParser;
import com.timevale.tgtext.bouncycastle.asn1.ASN1UTCTime;
import com.timevale.tgtext.bouncycastle.asn1.BERApplicationSpecificParser;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetStringParser;
import com.timevale.tgtext.bouncycastle.asn1.BERSequenceParser;
import com.timevale.tgtext.bouncycastle.asn1.BERSetParser;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObjectParser;
import com.timevale.tgtext.bouncycastle.asn1.BERTags;
import com.timevale.tgtext.bouncycastle.asn1.DERApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.DERBMPString;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERExternal;
import com.timevale.tgtext.bouncycastle.asn1.DERExternalParser;
import com.timevale.tgtext.bouncycastle.asn1.DERGeneralString;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DERNumericString;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERPrintableString;
import com.timevale.tgtext.bouncycastle.asn1.DERT61String;
import com.timevale.tgtext.bouncycastle.asn1.DERUTF8String;
import com.timevale.tgtext.bouncycastle.asn1.DERUniversalString;
import com.timevale.tgtext.bouncycastle.asn1.DERVisibleString;
import com.timevale.tgtext.bouncycastle.asn1.c;
import com.timevale.tgtext.bouncycastle.asn1.d;
import com.timevale.tgtext.bouncycastle.asn1.e;
import com.timevale.tgtext.bouncycastle.asn1.g;
import com.timevale.tgtext.bouncycastle.asn1.i;
import com.timevale.tgtext.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1InputStream
extends FilterInputStream
implements BERTags {
    private final int limit;
    private final boolean lazyEvaluate;
    private final byte[][] tmpBuffers;

    public ASN1InputStream(InputStream is) {
        this(is, i.a(is));
    }

    public ASN1InputStream(byte[] input) {
        this((InputStream)new ByteArrayInputStream(input), input.length);
    }

    public ASN1InputStream(byte[] input, boolean lazyEvaluate) {
        this(new ByteArrayInputStream(input), input.length, lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit) {
        this(input, limit, false);
    }

    public ASN1InputStream(InputStream input, boolean lazyEvaluate) {
        this(input, i.a(input), lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit, boolean lazyEvaluate) {
        super(input);
        this.limit = limit;
        this.lazyEvaluate = lazyEvaluate;
        this.tmpBuffers = new byte[11][];
    }

    int getLimit() {
        return this.limit;
    }

    protected int readLength() throws IOException {
        return ASN1InputStream.readLength(this, this.limit);
    }

    protected void readFully(byte[] bytes) throws IOException {
        if (Streams.readFully(this, bytes) != bytes.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected ASN1Primitive buildObject(int tag, int tagNo, int length) throws IOException {
        boolean isConstructed = (tag & 0x20) != 0;
        d defIn = new d(this, length);
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(isConstructed, tagNo, defIn.b());
        }
        if ((tag & 0x80) != 0) {
            return new ASN1StreamParser(defIn).readTaggedObject(isConstructed, tagNo);
        }
        if (isConstructed) {
            switch (tagNo) {
                case 4: {
                    ASN1EncodableVector v2 = this.buildDEREncodableVector(defIn);
                    ASN1OctetString[] strings = new ASN1OctetString[v2.size()];
                    for (int i2 = 0; i2 != strings.length; ++i2) {
                        strings[i2] = (ASN1OctetString)v2.get(i2);
                    }
                    return new BEROctetString(strings);
                }
                case 16: {
                    if (this.lazyEvaluate) {
                        return new g(defIn.b());
                    }
                    return c.a(this.buildDEREncodableVector(defIn));
                }
                case 17: {
                    return c.b(this.buildDEREncodableVector(defIn));
                }
                case 8: {
                    return new DERExternal(this.buildDEREncodableVector(defIn));
                }
            }
            throw new IOException("unknown tag " + tagNo + " encountered");
        }
        return ASN1InputStream.createPrimitiveDERObject(tagNo, defIn, this.tmpBuffers);
    }

    ASN1EncodableVector buildEncodableVector() throws IOException {
        ASN1Primitive o2;
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        while ((o2 = this.readObject()) != null) {
            v2.add(o2);
        }
        return v2;
    }

    ASN1EncodableVector buildDEREncodableVector(d dIn) throws IOException {
        return new ASN1InputStream(dIn).buildEncodableVector();
    }

    public ASN1Primitive readObject() throws IOException {
        int tag = this.read();
        if (tag <= 0) {
            if (tag == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int tagNo = ASN1InputStream.readTagNumber(this, tag);
        boolean isConstructed = (tag & 0x20) != 0;
        int length = this.readLength();
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            e indIn = new e(this, this.limit);
            ASN1StreamParser sp = new ASN1StreamParser(indIn, this.limit);
            if ((tag & 0x40) != 0) {
                return new BERApplicationSpecificParser(tagNo, sp).getLoadedObject();
            }
            if ((tag & 0x80) != 0) {
                return new BERTaggedObjectParser(true, tagNo, sp).getLoadedObject();
            }
            switch (tagNo) {
                case 4: {
                    return new BEROctetStringParser(sp).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(sp).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(sp).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(sp).getLoadedObject();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        try {
            return this.buildObject(tag, tagNo, length);
        }
        catch (IllegalArgumentException e2) {
            throw new ASN1Exception("corrupted stream detected", e2);
        }
    }

    static int readTagNumber(InputStream s2, int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            tagNo = 0;
            int b2 = s2.read();
            if ((b2 & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (b2 >= 0 && (b2 & 0x80) != 0) {
                tagNo |= b2 & 0x7F;
                tagNo <<= 7;
                b2 = s2.read();
            }
            if (b2 < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b2 & 0x7F;
        }
        return tagNo;
    }

    static int readLength(InputStream s2, int limit) throws IOException {
        int length = s2.read();
        if (length < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes: " + size);
            }
            length = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                int next = s2.read();
                if (next < 0) {
                    throw new EOFException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (length >= limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return length;
    }

    private static byte[] getBuffer(d defIn, byte[][] tmpBuffers) throws IOException {
        int len = defIn.a();
        if (defIn.a() < tmpBuffers.length) {
            byte[] buf = tmpBuffers[len];
            if (buf == null) {
                tmpBuffers[len] = new byte[len];
                buf = tmpBuffers[len];
            }
            Streams.readFully(defIn, buf);
            return buf;
        }
        return defIn.b();
    }

    private static char[] getBMPCharBuffer(d defIn) throws IOException {
        int ch2;
        int ch1;
        int len = defIn.a() / 2;
        char[] buf = new char[len];
        int totalRead = 0;
        while (totalRead < len && (ch1 = defIn.read()) >= 0 && (ch2 = defIn.read()) >= 0) {
            buf[totalRead++] = (char)(ch1 << 8 | ch2 & 0xFF);
        }
        return buf;
    }

    static ASN1Primitive createPrimitiveDERObject(int tagNo, d defIn, byte[][] tmpBuffers) throws IOException {
        switch (tagNo) {
            case 3: {
                return DERBitString.fromInputStream(defIn.a(), defIn);
            }
            case 30: {
                return new DERBMPString(ASN1InputStream.getBMPCharBuffer(defIn));
            }
            case 1: {
                return ASN1Boolean.fromOctetString(ASN1InputStream.getBuffer(defIn, tmpBuffers));
            }
            case 10: {
                return ASN1Enumerated.fromOctetString(ASN1InputStream.getBuffer(defIn, tmpBuffers));
            }
            case 24: {
                return new ASN1GeneralizedTime(defIn.b());
            }
            case 27: {
                return new DERGeneralString(defIn.b());
            }
            case 22: {
                return new DERIA5String(defIn.b());
            }
            case 2: {
                return new ASN1Integer(defIn.b());
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(defIn.b());
            }
            case 6: {
                return ASN1ObjectIdentifier.fromOctetString(ASN1InputStream.getBuffer(defIn, tmpBuffers));
            }
            case 4: {
                return new DEROctetString(defIn.b());
            }
            case 19: {
                return new DERPrintableString(defIn.b());
            }
            case 20: {
                return new DERT61String(defIn.b());
            }
            case 28: {
                return new DERUniversalString(defIn.b());
            }
            case 23: {
                return new ASN1UTCTime(defIn.b());
            }
            case 12: {
                return new DERUTF8String(defIn.b());
            }
            case 26: {
                return new DERVisibleString(defIn.b());
            }
        }
        throw new IOException("unknown tag " + tagNo + " encountered");
    }
}

