/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cms.CMSAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.SignerInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.SignerInfoGeneratorBuilder;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaSimpleSignerInfoGeneratorBuilder {
    private a helper = new a();
    private boolean hasNoSignedAttributes;
    private CMSAttributeTableGenerator signedGen;
    private CMSAttributeTableGenerator unsignedGen;

    public JcaSimpleSignerInfoGeneratorBuilder setProvider(String providerName) throws OperatorCreationException {
        this.helper = new b(providerName);
        return this;
    }

    public JcaSimpleSignerInfoGeneratorBuilder setProvider(Provider provider) throws OperatorCreationException {
        this.helper = new c(provider);
        return this;
    }

    public JcaSimpleSignerInfoGeneratorBuilder setDirectSignature(boolean hasNoSignedAttributes) {
        this.hasNoSignedAttributes = hasNoSignedAttributes;
        return this;
    }

    public JcaSimpleSignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator signedGen) {
        this.signedGen = signedGen;
        return this;
    }

    public JcaSimpleSignerInfoGeneratorBuilder setSignedAttributeGenerator(AttributeTable attrTable) {
        this.signedGen = new DefaultSignedAttributeTableGenerator(attrTable);
        return this;
    }

    public JcaSimpleSignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator unsignedGen) {
        this.unsignedGen = unsignedGen;
        return this;
    }

    public SignerInfoGenerator build(String algorithmName, PrivateKey privateKey, X509Certificate certificate) throws OperatorCreationException, CertificateEncodingException {
        ContentSigner contentSigner = this.helper.a(algorithmName, privateKey);
        return this.configureAndBuild().build(contentSigner, new JcaX509CertificateHolder(certificate));
    }

    public SignerInfoGenerator build(String algorithmName, PrivateKey privateKey, byte[] keyIdentifier) throws OperatorCreationException, CertificateEncodingException {
        ContentSigner contentSigner = this.helper.a(algorithmName, privateKey);
        return this.configureAndBuild().build(contentSigner, keyIdentifier);
    }

    private SignerInfoGeneratorBuilder configureAndBuild() throws OperatorCreationException {
        SignerInfoGeneratorBuilder infoGeneratorBuilder = new SignerInfoGeneratorBuilder(this.helper.a());
        infoGeneratorBuilder.setDirectSignature(this.hasNoSignedAttributes);
        infoGeneratorBuilder.setSignedAttributeGenerator(this.signedGen);
        infoGeneratorBuilder.setUnsignedAttributeGenerator(this.unsignedGen);
        return infoGeneratorBuilder;
    }

    private class c
    extends a {
        private final Provider c;

        public c(Provider provider) {
            this.c = provider;
        }

        @Override
        ContentSigner a(String algorithm, PrivateKey privateKey) throws OperatorCreationException {
            return new JcaContentSignerBuilder(algorithm).setProvider(this.c).build(privateKey);
        }

        @Override
        DigestCalculatorProvider a() throws OperatorCreationException {
            return new JcaDigestCalculatorProviderBuilder().setProvider(this.c).build();
        }
    }

    private class b
    extends a {
        private final String c;

        public b(String providerName) {
            this.c = providerName;
        }

        @Override
        ContentSigner a(String algorithm, PrivateKey privateKey) throws OperatorCreationException {
            return new JcaContentSignerBuilder(algorithm).setProvider(this.c).build(privateKey);
        }

        @Override
        DigestCalculatorProvider a() throws OperatorCreationException {
            return new JcaDigestCalculatorProviderBuilder().setProvider(this.c).build();
        }
    }

    private class a {
        private a() {
        }

        ContentSigner a(String algorithm, PrivateKey privateKey) throws OperatorCreationException {
            return new JcaContentSignerBuilder(algorithm).build(privateKey);
        }

        DigestCalculatorProvider a() throws OperatorCreationException {
            return new JcaDigestCalculatorProviderBuilder().build();
        }
    }
}

