/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.tsp.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.Evidence;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampAndCRL;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampedData;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampedDataParser;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampTokenInfo;
import com.timevale.tgtext.bouncycastle.tsp.cms.ImprintDigestInvalidException;
import com.timevale.tgtext.bouncycastle.tsp.cms.a;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class b {
    private final TimeStampAndCRL[] a;
    private final a b;

    b(TimeStampedData timeStampedData) {
        this.b = new a(timeStampedData.getMetaData());
        Evidence evidence = timeStampedData.getTemporalEvidence();
        this.a = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    b(TimeStampedDataParser timeStampedData) throws IOException {
        this.b = new a(timeStampedData.getMetaData());
        Evidence evidence = timeStampedData.getTemporalEvidence();
        this.a = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    TimeStampToken a(TimeStampAndCRL timeStampAndCRL) throws CMSException {
        ContentInfo timeStampToken = timeStampAndCRL.getTimeStampToken();
        try {
            TimeStampToken token = new TimeStampToken(timeStampToken);
            return token;
        }
        catch (IOException e2) {
            throw new CMSException("unable to parse token data: " + e2.getMessage(), e2);
        }
        catch (TSPException tSPException) {
            TSPException e3 = tSPException;
            if (tSPException.getCause() instanceof CMSException) {
                throw (CMSException)e3.getCause();
            }
            throw new CMSException("token data invalid: " + e3.getMessage(), e3);
        }
        catch (IllegalArgumentException e4) {
            throw new CMSException("token data invalid: " + e4.getMessage(), e4);
        }
    }

    void a(DigestCalculator calculator) throws CMSException {
        this.b.a(calculator);
    }

    DigestCalculator a(DigestCalculatorProvider calculatorProvider) throws OperatorCreationException {
        try {
            TimeStampToken token = this.a(this.a[0]);
            TimeStampTokenInfo info = token.getTimeStampInfo();
            ASN1ObjectIdentifier algOID = info.getMessageImprintAlgOID();
            DigestCalculator calc = calculatorProvider.get(new AlgorithmIdentifier(algOID));
            this.a(calc);
            return calc;
        }
        catch (CMSException e2) {
            throw new OperatorCreationException("unable to extract algorithm ID: " + e2.getMessage(), e2);
        }
    }

    TimeStampToken[] a() throws CMSException {
        TimeStampToken[] tokens = new TimeStampToken[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            tokens[i2] = this.a(this.a[i2]);
        }
        return tokens;
    }

    TimeStampAndCRL[] b() {
        return this.a;
    }

    byte[] b(DigestCalculator calculator) throws CMSException {
        TimeStampAndCRL tspToken = this.a[this.a.length - 1];
        OutputStream out = calculator.getOutputStream();
        try {
            out.write(tspToken.getEncoded("DER"));
            out.close();
            return calculator.getDigest();
        }
        catch (IOException e2) {
            throw new CMSException("exception calculating hash: " + e2.getMessage(), e2);
        }
    }

    void a(DigestCalculatorProvider calculatorProvider, byte[] dataDigest) throws ImprintDigestInvalidException, CMSException {
        byte[] currentDigest = dataDigest;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            try {
                TimeStampToken token = this.a(this.a[i2]);
                if (i2 > 0) {
                    TimeStampTokenInfo info = token.getTimeStampInfo();
                    DigestCalculator calculator = calculatorProvider.get(info.getHashAlgorithm());
                    calculator.getOutputStream().write(this.a[i2 - 1].getEncoded("DER"));
                    currentDigest = calculator.getDigest();
                }
                this.a(token, currentDigest);
                continue;
            }
            catch (IOException e2) {
                throw new CMSException("exception calculating hash: " + e2.getMessage(), e2);
            }
            catch (OperatorCreationException e3) {
                throw new CMSException("cannot create digest: " + e3.getMessage(), e3);
            }
        }
    }

    void a(DigestCalculatorProvider calculatorProvider, byte[] dataDigest, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        byte[] encToken;
        byte[] currentDigest = dataDigest;
        try {
            encToken = timeStampToken.getEncoded();
        }
        catch (IOException e2) {
            throw new CMSException("exception encoding timeStampToken: " + e2.getMessage(), e2);
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            try {
                TimeStampToken token = this.a(this.a[i2]);
                if (i2 > 0) {
                    TimeStampTokenInfo info = token.getTimeStampInfo();
                    DigestCalculator calculator = calculatorProvider.get(info.getHashAlgorithm());
                    calculator.getOutputStream().write(this.a[i2 - 1].getEncoded("DER"));
                    currentDigest = calculator.getDigest();
                }
                this.a(token, currentDigest);
                if (!Arrays.areEqual(token.getEncoded(), encToken)) continue;
                return;
            }
            catch (IOException e3) {
                throw new CMSException("exception calculating hash: " + e3.getMessage(), e3);
            }
            catch (OperatorCreationException e4) {
                throw new CMSException("cannot create digest: " + e4.getMessage(), e4);
            }
        }
        throw new ImprintDigestInvalidException("passed in token not associated with timestamps present", timeStampToken);
    }

    private void a(TimeStampToken timeStampToken, byte[] digest) throws ImprintDigestInvalidException {
        TimeStampTokenInfo info = timeStampToken.getTimeStampInfo();
        byte[] tsrMessageDigest = info.getMessageImprintDigest();
        if (!Arrays.areEqual(digest, tsrMessageDigest)) {
            throw new ImprintDigestInvalidException("hash calculated is different from MessageImprintDigest found in TimeStampToken", timeStampToken);
        }
    }

    String c() {
        return this.b.a();
    }

    String d() {
        return this.b.b();
    }

    AttributeTable e() {
        return new AttributeTable(this.b.c());
    }
}

