/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.BERSequenceGenerator;
import com.timevale.tgtext.bouncycastle.asn1.BERSet;
import com.timevale.tgtext.bouncycastle.asn1.DERInteger;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cms.AuthenticatedData;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSAuthenticatedGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.RecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceCMSMacCalculatorBuilder;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.MacCalculator;
import com.timevale.tgtext.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CMSAuthenticatedDataStreamGenerator
extends CMSAuthenticatedGenerator {
    private int bufferSize;
    private boolean berEncodeRecipientSet;
    private MacCalculator macCalculator;

    public CMSAuthenticatedDataStreamGenerator() {
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean useBerEncodingForRecipients) {
        this.berEncodeRecipientSet = useBerEncodingForRecipients;
    }

    public OutputStream open(OutputStream out, MacCalculator macCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, out, macCalculator);
    }

    public OutputStream open(OutputStream out, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, out, macCalculator, digestCalculator);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, MacCalculator macCalculator) throws CMSException {
        return this.open(dataType, out, macCalculator, null);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        this.macCalculator = macCalculator;
        try {
            ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
            for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
                recipientInfos.add(recipient.generate(macCalculator.getKey()));
            }
            BERSequenceGenerator cGen = new BERSequenceGenerator(out);
            cGen.addObject(CMSObjectIdentifiers.authenticatedData);
            BERSequenceGenerator authGen = new BERSequenceGenerator(cGen.getRawOutputStream(), 0, true);
            authGen.addObject(new DERInteger(AuthenticatedData.calculateVersion(this.originatorInfo)));
            if (this.originatorInfo != null) {
                authGen.addObject(new DERTaggedObject(false, 0, this.originatorInfo));
            }
            if (this.berEncodeRecipientSet) {
                authGen.getRawOutputStream().write(new BERSet(recipientInfos).getEncoded());
            } else {
                authGen.getRawOutputStream().write(new DERSet(recipientInfos).getEncoded());
            }
            AlgorithmIdentifier macAlgId = macCalculator.getAlgorithmIdentifier();
            authGen.getRawOutputStream().write(macAlgId.getEncoded());
            if (digestCalculator != null) {
                authGen.addObject(new DERTaggedObject(false, 1, digestCalculator.getAlgorithmIdentifier()));
            }
            BERSequenceGenerator eiGen = new BERSequenceGenerator(authGen.getRawOutputStream());
            eiGen.addObject(dataType);
            OutputStream octetStream = i.a(eiGen.getRawOutputStream(), 0, false, this.bufferSize);
            TeeOutputStream mOut = digestCalculator != null ? new TeeOutputStream(octetStream, digestCalculator.getOutputStream()) : new TeeOutputStream(octetStream, macCalculator.getOutputStream());
            return new a(macCalculator, digestCalculator, dataType, mOut, cGen, authGen, eiGen);
        }
        catch (IOException e2) {
            throw new CMSException("exception decoding algorithm parameters.", e2);
        }
    }

    public CMSAuthenticatedDataStreamGenerator(SecureRandom rand) {
        super(rand);
    }

    public OutputStream open(OutputStream out, String encryptionOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        this.convertOldRecipients(this.rand, i.a(provider));
        return this.open(out, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(encryptionOID)).setSecureRandom(this.rand).setProvider(provider).build());
    }

    public OutputStream open(OutputStream out, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        this.convertOldRecipients(this.rand, provider);
        return this.open(out, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(encryptionOID)).setSecureRandom(this.rand).setProvider(provider).build());
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        this.convertOldRecipients(this.rand, i.a(provider));
        return this.open(out, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(encryptionOID), keySize).setSecureRandom(this.rand).setProvider(provider).build());
    }

    public OutputStream open(OutputStream out, String encryptionOID, int keySize, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        this.convertOldRecipients(this.rand, provider);
        return this.open(out, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(encryptionOID), keySize).setSecureRandom(this.rand).setProvider(provider).build());
    }

    private class a
    extends OutputStream {
        private OutputStream b;
        private BERSequenceGenerator c;
        private BERSequenceGenerator d;
        private BERSequenceGenerator e;
        private MacCalculator f;
        private DigestCalculator g;
        private ASN1ObjectIdentifier h;

        public a(MacCalculator macCalculator, DigestCalculator digestCalculator, ASN1ObjectIdentifier contentType, OutputStream dataStream, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this.f = macCalculator;
            this.g = digestCalculator;
            this.h = contentType;
            this.b = dataStream;
            this.c = cGen;
            this.d = envGen;
            this.e = eiGen;
        }

        @Override
        public void write(int b2) throws IOException {
            this.b.write(b2);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.b.write(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.b.write(bytes);
        }

        @Override
        public void close() throws IOException {
            Map parameters;
            this.b.close();
            this.e.close();
            if (this.g != null) {
                parameters = Collections.unmodifiableMap(CMSAuthenticatedDataStreamGenerator.this.getBaseParameters(this.h, this.g.getAlgorithmIdentifier(), this.g.getDigest()));
                if (CMSAuthenticatedDataStreamGenerator.this.authGen == null) {
                    CMSAuthenticatedDataStreamGenerator.this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
                }
                DERSet authed = new DERSet(CMSAuthenticatedDataStreamGenerator.this.authGen.getAttributes(parameters).toASN1EncodableVector());
                OutputStream mOut = this.f.getOutputStream();
                mOut.write(authed.getEncoded("DER"));
                mOut.close();
                this.d.addObject(new DERTaggedObject(false, 2, authed));
            } else {
                parameters = Collections.unmodifiableMap(new HashMap());
            }
            this.d.addObject(new DEROctetString(this.f.getMac()));
            if (CMSAuthenticatedDataStreamGenerator.this.unauthGen != null) {
                this.d.addObject(new DERTaggedObject(false, 3, new BERSet(CMSAuthenticatedDataStreamGenerator.this.unauthGen.getAttributes(parameters).toASN1EncodableVector())));
            }
            this.d.close();
            this.c.close();
        }
    }
}

