/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.DHParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.Certificate;
import com.timevale.tgtext.bouncycastle.crypto.tls.CertificateRequest;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsDHUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsKeyExchange;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsPSKIdentity;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsRSAUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.crypto.util.PublicKeyFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

class m
implements TlsKeyExchange {
    protected TlsClientContext a;
    protected int b;
    protected TlsPSKIdentity c;
    protected byte[] d = null;
    protected DHPublicKeyParameters e = null;
    protected DHPrivateKeyParameters f = null;
    protected AsymmetricKeyParameter g = null;
    protected RSAKeyParameters h = null;
    protected byte[] i;

    m(TlsClientContext context, int keyExchange, TlsPSKIdentity pskIdentity) {
        switch (keyExchange) {
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.a = context;
        this.b = keyExchange;
        this.c = pskIdentity;
    }

    @Override
    public void skipServerCertificate() throws IOException {
        if (this.b == 15) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.b != 15) {
            throw new TlsFatalAlert(10);
        }
        com.timevale.tgtext.bouncycastle.asn1.x509.Certificate x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.g = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43);
        }
        if (this.g.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        this.h = this.a((RSAKeyParameters)this.g);
        TlsUtils.validateKeyUsage(x509Cert, 32);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        if (this.b == 14) {
            throw new TlsFatalAlert(10);
        }
        this.d = new byte[0];
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        this.d = TlsUtils.readOpaque16(is);
        if (this.b == 14) {
            byte[] pBytes = TlsUtils.readOpaque16(is);
            byte[] gBytes = TlsUtils.readOpaque16(is);
            byte[] YsBytes = TlsUtils.readOpaque16(is);
            BigInteger p2 = new BigInteger(1, pBytes);
            BigInteger g2 = new BigInteger(1, gBytes);
            BigInteger Ys = new BigInteger(1, YsBytes);
            this.e = TlsDHUtils.validateDHPublicKey(new DHPublicKeyParameters(Ys, new DHParameters(p2, g2)));
        }
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream os) throws IOException {
        if (this.d == null || this.d.length == 0) {
            this.c.skipIdentityHint();
        } else {
            this.c.notifyIdentityHint(this.d);
        }
        byte[] psk_identity = this.c.getPSKIdentity();
        TlsUtils.writeOpaque16(psk_identity, os);
        if (this.b == 15) {
            this.i = TlsRSAUtils.generateEncryptedPreMasterSecret(this.a, this.h, os);
            return;
        }
        if (this.b == 14) {
            this.f = TlsDHUtils.generateEphemeralClientKeyExchange(this.a.getSecureRandom(), this.e.getParameters(), os);
        }
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        byte[] psk = this.c.getPSK();
        byte[] other_secret = this.a(psk.length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4 + other_secret.length + psk.length);
        TlsUtils.writeOpaque16(other_secret, buf);
        TlsUtils.writeOpaque16(psk, buf);
        return buf.toByteArray();
    }

    protected byte[] a(int pskLength) {
        if (this.b == 14) {
            return TlsDHUtils.calculateDHBasicAgreement(this.e, this.f);
        }
        if (this.b == 15) {
            return this.i;
        }
        return new byte[pskLength];
    }

    protected RSAKeyParameters a(RSAKeyParameters key) throws IOException {
        if (!key.getExponent().isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        return key;
    }
}

