/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.validator;

import esign.utils.exception.aj;
import esign.utils.s;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CodeValidator {
    INSTANCE;

    private static Logger LOGGER;
    private static final int LENGTH_CODE_CODE_USC = 18;

    public String convCodeORG(String codeUSC) throws aj {
        if (18 != codeUSC.length()) {
            return this.transCodeORG(codeUSC);
        }
        return codeUSC.substring(8, 17);
    }

    public String uniteCodeORG(String code) throws aj {
        if (code.length() != 18) {
            return this.transCodeORG(code);
        }
        return this.convCodeORG(code);
    }

    private String transCodeORG(String code) {
        String[] split = code.split("-");
        if (split.length >= 2) {
            return split[0] + split[1];
        }
        return code;
    }

    public boolean organCode(String code, boolean strict) {
        return this.validate(CodeValidateRule.ORG_CODE, code.toUpperCase(), strict);
    }

    public boolean socialCreditCode(String code, boolean strict) {
        return this.validate(CodeValidateRule.ORG_CODE, code.toUpperCase(), strict);
    }

    public boolean idcardPRC(String code, boolean strict) {
        return this.validate(CodeValidateRule.IDCARD_PRC_15, code.toUpperCase(), strict) || this.validate(CodeValidateRule.IDCARD_PRC_18, code.toUpperCase(), strict);
    }

    public boolean idcardHK(String code, boolean strict) {
        return this.validate(CodeValidateRule.IDCARD_HK, code.toUpperCase(), strict);
    }

    public boolean idcardMAC(String code, boolean strict) {
        return this.validate(CodeValidateRule.IDCARD_MAC, code.toUpperCase(), strict);
    }

    public boolean idcardTW(String code, boolean strict) {
        return this.validate(CodeValidateRule.IDCARD_TW, code.toUpperCase(), strict);
    }

    public boolean passPortHK(String code, boolean strict) {
        return this.validate(CodeValidateRule.PASS_HK, code.toUpperCase(), strict);
    }

    public boolean passPortMAC(String code, boolean strict) {
        return this.validate(CodeValidateRule.PASS_MAC, code.toUpperCase(), strict);
    }

    public boolean passPortTW(String code, boolean strict) {
        return this.validate(CodeValidateRule.PASS_TW, code.toUpperCase(), strict);
    }

    private boolean validate(CodeValidateRule rule, String code, boolean strict) {
        Matcher m2 = rule.regx.matcher(code);
        if (!m2.matches()) {
            LOGGER.error("code format invalid. code:{}, regx:{}", (Object)code, (Object)rule.regx.pattern());
            return false;
        }
        if (s.a(rule.seq) || null == rule.wi) {
            return true;
        }
        char check = code.charAt(code.length() - 1);
        char[] raw = code.substring(0, code.length() - 2).toCharArray();
        if (!strict) {
            return true;
        }
        return check == this.checksum(rule, raw, check);
    }

    private char checksum(CodeValidateRule rule, char[] code, char check) {
        int sum = 0;
        for (int i2 = 0; i2 < code.length; ++i2) {
            sum += rule.seq.indexOf(code[i2]) * rule.wi[i2];
        }
        int c2 = rule.mod - sum % rule.mod;
        return rule.checksum.charAt(c2);
    }

    static {
        LOGGER = LoggerFactory.getLogger(CodeValidator.class);
    }

    private static enum CodeValidateRule {
        ORG_CODE("^([0-9A-Z]){8}[-]?[0-9A-Z]$", "0123456789ABCDEFGHIGKLMNOPQURSTUVWXYZ", "0123456789X0", new int[]{3, 7, 9, 10, 5, 8, 4, 2}, 11),
        SOC_CODE("^([0-9A-Z]{2})([0-9]{6})([0-9A-Z]){10}$", "0123456789ABCDEFGHJKLMNPQRTUWXY", "0123456789ABCDEFGHJKLMNPQRTUWXY0", new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28}, 31),
        IDCARD_PRC_15("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$"),
        IDCARD_PRC_18("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9]|x|X){1}$"),
        IDCARD_TW("^[a-zA-Z]{1}[12]{1}\\d{8}$"),
        IDCARD_MAC("^[157]{1}\\d{6}[0-9A-Z]{1}$"),
        IDCARD_HK("^[A-Z]{1}\\d{6}[0-9A]{1}$"),
        PASSPORT("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9]|X){1}$"),
        PASS_HK("^[Hh]{1}([0-9]{10}|[0-9]{8})$"),
        PASS_MAC("^[Mm]{1}([0-9]{10}|[0-9]{8})$"),
        PASS_TW("^[0-9]{8}|[0-9]{10} $");

        private Pattern regx;
        private String seq;
        private String checksum;
        private int[] wi;
        private int mod;

        private CodeValidateRule(String regx, String seq, String checksum, int[] wi, int mod) {
            this.regx = Pattern.compile(regx);
            this.seq = seq;
            this.checksum = checksum;
            this.wi = wi;
            this.mod = mod;
        }

        private CodeValidateRule(String regx) {
            this.regx = Pattern.compile(regx);
        }
    }
}

