/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pkcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.MacData;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.Pfx;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import com.timevale.tgtext.bouncycastle.pkcs.PKCSException;
import com.timevale.tgtext.bouncycastle.pkcs.a;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;

public class PKCS12PfxPdu {
    private Pfx pfx;

    public PKCS12PfxPdu(Pfx pfx) {
        this.pfx = pfx;
    }

    public ContentInfo[] getContentInfos() {
        ASN1Sequence seq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
        ContentInfo[] content = new ContentInfo[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            content[i2] = ContentInfo.getInstance(seq.getObjectAt(i2));
        }
        return content;
    }

    public boolean hasMac() {
        return this.pfx.getMacData() != null;
    }

    public boolean isMacValid(PKCS12MacCalculatorBuilderProvider macCalcProviderBuilder, char[] password) throws PKCSException {
        if (this.hasMac()) {
            MacData pfxmData = this.pfx.getMacData();
            a mdGen = new a(macCalcProviderBuilder.get(new AlgorithmIdentifier(pfxmData.getMac().getAlgorithmId().getAlgorithm(), (ASN1Encodable)new PKCS12PBEParams(pfxmData.getSalt(), pfxmData.getIterationCount().intValue()))));
            try {
                MacData mData = mdGen.a(password, ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
                return Arrays.constantTimeAreEqual(mData.getEncoded(), this.pfx.getMacData().getEncoded());
            }
            catch (IOException e2) {
                throw new PKCSException("unable to process AuthSafe: " + e2.getMessage());
            }
        }
        throw new IllegalStateException("no MAC present on PFX");
    }

    public Pfx toASN1Structure() {
        return this.pfx;
    }
}

