/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.modes.gcm;

import com.timevale.tgtext.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.timevale.tgtext.bouncycastle.crypto.modes.gcm.a;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.util.Vector;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    @Override
    public void init(byte[] x2) {
        if (this.lookupPowX2 != null && Arrays.areEqual(x2, (byte[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(Arrays.clone(x2));
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        byte[] y2 = a.a();
        int bit = 0;
        while (pow > 0L) {
            if ((pow & 1L) != 0L) {
                this.ensureAvailable(bit);
                a.a(y2, (byte[])this.lookupPowX2.elementAt(bit));
            }
            ++bit;
            pow >>>= 1;
        }
        System.arraycopy(y2, 0, output, 0, 16);
    }

    private void ensureAvailable(int bit) {
        int count = this.lookupPowX2.size();
        if (count <= bit) {
            byte[] tmp = (byte[])this.lookupPowX2.elementAt(count - 1);
            do {
                tmp = Arrays.clone(tmp);
                a.a(tmp, tmp);
                this.lookupPowX2.addElement(tmp);
            } while (++count <= bit);
        }
    }
}

