/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.util;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.oiw.ElGamalParameter;
import com.timevale.tgtext.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.DHParameter;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.timevale.tgtext.bouncycastle.asn1.sec.SECNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.DSAParameter;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x9.DHDomainParameters;
import com.timevale.tgtext.bouncycastle.asn1.x9.DHPublicKey;
import com.timevale.tgtext.bouncycastle.asn1.x9.DHValidationParms;
import com.timevale.tgtext.bouncycastle.asn1.x9.X962NamedCurves;
import com.timevale.tgtext.bouncycastle.asn1.x9.X962Parameters;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ECParameters;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ECPoint;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.DHParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DHValidationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECDomainParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ElGamalParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAKeyParameters;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PublicKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] keyInfoData) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(keyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithm();
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption) || algId.getAlgorithm().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            RSAPublicKey pubKey = RSAPublicKey.getInstance(keyInfo.parsePublicKey());
            return new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DHPublicKey dhPublicKey = DHPublicKey.getInstance(keyInfo.parsePublicKey());
            BigInteger y2 = dhPublicKey.getY().getValue();
            DHDomainParameters dhParams = DHDomainParameters.getInstance(algId.getParameters());
            BigInteger p2 = dhParams.getP().getValue();
            BigInteger g2 = dhParams.getG().getValue();
            BigInteger q2 = dhParams.getQ().getValue();
            BigInteger j2 = null;
            if (dhParams.getJ() != null) {
                j2 = dhParams.getJ().getValue();
            }
            DHValidationParameters validation = null;
            DHValidationParms dhValidationParms = dhParams.getValidationParms();
            if (dhValidationParms != null) {
                byte[] seed = dhValidationParms.getSeed().getBytes();
                BigInteger pgenCounter = dhValidationParms.getPgenCounter().getValue();
                validation = new DHValidationParameters(seed, pgenCounter.intValue());
            }
            return new DHPublicKeyParameters(y2, new DHParameters(p2, g2, q2, j2, validation));
        }
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = DHParameter.getInstance(algId.getParameters());
            ASN1Integer derY = (ASN1Integer)keyInfo.parsePublicKey();
            BigInteger lVal = params.getL();
            int l2 = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l2);
            return new DHPublicKeyParameters(derY.getValue(), dhParams);
        }
        if (algId.getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = new ElGamalParameter((ASN1Sequence)algId.getParameters());
            ASN1Integer derY = (ASN1Integer)keyInfo.parsePublicKey();
            return new ElGamalPublicKeyParameters(derY.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_dsa) || algId.getAlgorithm().equals(OIWObjectIdentifiers.dsaWithSHA1)) {
            ASN1Integer derY = (ASN1Integer)keyInfo.parsePublicKey();
            ASN1Encodable de2 = algId.getParameters();
            DSAParameters parameters = null;
            if (de2 != null) {
                DSAParameter params = DSAParameter.getInstance(de2.toASN1Primitive());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPublicKeyParameters(derY.getValue(), parameters);
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X9ECParameters x9;
            X962Parameters params = new X962Parameters((ASN1Primitive)algId.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
                x9 = X962NamedCurves.getByOID(oid);
                if (x9 == null && (x9 = SECNamedCurves.getByOID(oid)) == null && (x9 = NISTNamedCurves.getByOID(oid)) == null) {
                    x9 = TeleTrusTNamedCurves.getByOID(oid);
                }
            } else {
                x9 = X9ECParameters.getInstance(params.getParameters());
            }
            DEROctetString key = new DEROctetString(keyInfo.getPublicKeyData().getBytes());
            X9ECPoint derQ = new X9ECPoint(x9.getCurve(), key);
            ECDomainParameters dParams = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            return new ECPublicKeyParameters(derQ.getPoint(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

