/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.TargetInformation;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.jce.exception.ExtCertPathValidatorException;
import com.timevale.tgtext.bouncycastle.jce.provider.AnnotatedException;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.jce.provider.CertPathValidatorUtilities;
import com.timevale.tgtext.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import com.timevale.tgtext.bouncycastle.jce.provider.b;
import com.timevale.tgtext.bouncycastle.jce.provider.f;
import com.timevale.tgtext.bouncycastle.x509.ExtendedPKIXBuilderParameters;
import com.timevale.tgtext.bouncycastle.x509.ExtendedPKIXParameters;
import com.timevale.tgtext.bouncycastle.x509.PKIXAttrCertChecker;
import com.timevale.tgtext.bouncycastle.x509.X509AttributeCertificate;
import com.timevale.tgtext.bouncycastle.x509.X509CertStoreSelector;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class e {
    private static final String a = X509Extensions.TargetInformation.getId();
    private static final String b = X509Extensions.NoRevAvail.getId();
    private static final String c = X509Extensions.CRLDistributionPoints.getId();
    private static final String d = X509Extensions.AuthorityInfoAccess.getId();

    e() {
    }

    protected static void a(X509AttributeCertificate attrCert, CertPath certPath, CertPath holderCertPath, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        Set<String> set = attrCert.getCriticalExtensionOIDs();
        if (set.contains(a)) {
            try {
                TargetInformation.getInstance(CertPathValidatorUtilities.getExtensionValue(attrCert, a));
            }
            catch (AnnotatedException e2) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", e2);
            }
            catch (IllegalArgumentException e3) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", e3);
            }
        }
        set.remove(a);
        Iterator it = pkixParams.getAttrCertCheckers().iterator();
        while (it.hasNext()) {
            ((PKIXAttrCertChecker)it.next()).check(attrCert, certPath, holderCertPath, set);
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Attribute certificate contains unsupported critical extensions: " + set);
        }
    }

    protected static void a(X509AttributeCertificate attrCert, ExtendedPKIXParameters paramsPKIX, X509Certificate issuerCert, Date validDate, List certPathCerts) throws CertPathValidatorException {
        if (paramsPKIX.isRevocationEnabled()) {
            if (attrCert.getExtensionValue(b) == null) {
                ExtendedPKIXParameters paramsPKIXClone;
                CRLDistPoint crldp;
                try {
                    crldp = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(attrCert, c));
                }
                catch (AnnotatedException e2) {
                    throw new CertPathValidatorException("CRL distribution point extension could not be read.", e2);
                }
                try {
                    CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(crldp, paramsPKIX);
                }
                catch (AnnotatedException e3) {
                    throw new CertPathValidatorException("No additional CRL locations could be decoded from CRL distribution point extension.", e3);
                }
                b certStatus = new b();
                f reasonsMask = new f();
                AnnotatedException lastException = null;
                boolean validCrlFound = false;
                if (crldp != null) {
                    DistributionPoint[] dps;
                    try {
                        dps = crldp.getDistributionPoints();
                    }
                    catch (Exception e4) {
                        throw new ExtCertPathValidatorException("Distribution points could not be read.", e4);
                    }
                    try {
                        for (int i2 = 0; i2 < dps.length && certStatus.b() == 11 && !reasonsMask.a(); ++i2) {
                            paramsPKIXClone = (ExtendedPKIXParameters)paramsPKIX.clone();
                            e.a(dps[i2], attrCert, paramsPKIXClone, validDate, issuerCert, certStatus, reasonsMask, certPathCerts);
                            validCrlFound = true;
                        }
                    }
                    catch (AnnotatedException e5) {
                        lastException = new AnnotatedException("No valid CRL for distribution point found.", e5);
                    }
                }
                if (certStatus.b() == 11 && !reasonsMask.a()) {
                    try {
                        ASN1Primitive issuer;
                        try {
                            issuer = new ASN1InputStream(((X500Principal)attrCert.getIssuer().getPrincipals()[0]).getEncoded()).readObject();
                        }
                        catch (Exception e6) {
                            throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", e6);
                        }
                        DistributionPoint dp2 = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, issuer))), null, null);
                        paramsPKIXClone = (ExtendedPKIXParameters)paramsPKIX.clone();
                        e.a(dp2, attrCert, paramsPKIXClone, validDate, issuerCert, certStatus, reasonsMask, certPathCerts);
                        validCrlFound = true;
                    }
                    catch (AnnotatedException e7) {
                        lastException = new AnnotatedException("No valid CRL for distribution point found.", e7);
                    }
                }
                if (!validCrlFound) {
                    throw new ExtCertPathValidatorException("No valid CRL found.", lastException);
                }
                if (certStatus.b() != 11) {
                    String message = "Attribute certificate revocation after " + certStatus.a();
                    message = message + ", reason: " + RFC3280CertPathUtilities.crlReasons[certStatus.b()];
                    throw new CertPathValidatorException(message);
                }
                if (!reasonsMask.a() && certStatus.b() == 11) {
                    certStatus.a(12);
                }
                if (certStatus.b() == 12) {
                    throw new CertPathValidatorException("Attribute certificate status could not be determined.");
                }
                return;
            }
            if (attrCert.getExtensionValue(c) != null || attrCert.getExtensionValue(d) != null) {
                throw new CertPathValidatorException("No rev avail extension is set, but also an AC revocation pointer.");
            }
        }
    }

    protected static void a(X509AttributeCertificate attrCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        for (String oid : pkixParams.getProhibitedACAttributes()) {
            if (attrCert.getAttributes(oid) == null) continue;
            throw new CertPathValidatorException("Attribute certificate contains prohibited attribute: " + oid + ".");
        }
        for (String oid : pkixParams.getNecessaryACAttributes()) {
            if (attrCert.getAttributes(oid) != null) continue;
            throw new CertPathValidatorException("Attribute certificate does not contain necessary attribute: " + oid + ".");
        }
    }

    protected static void b(X509AttributeCertificate attrCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        try {
            attrCert.checkValidity(CertPathValidatorUtilities.getValidDate(pkixParams));
            return;
        }
        catch (CertificateExpiredException e2) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", e2);
        }
        catch (CertificateNotYetValidException e3) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", e3);
        }
    }

    protected static void a(X509Certificate acIssuerCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        Set set = pkixParams.getTrustedACIssuers();
        boolean trusted = false;
        for (TrustAnchor anchor : set) {
            if (!acIssuerCert.getSubjectX500Principal().getName("RFC2253").equals(anchor.getCAName()) && !acIssuerCert.equals(anchor.getTrustedCert())) continue;
            trusted = true;
        }
        if (!trusted) {
            throw new CertPathValidatorException("Attribute certificate issuer is not directly trusted.");
        }
    }

    protected static void b(X509Certificate acIssuerCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        if (acIssuerCert.getKeyUsage() != null && !acIssuerCert.getKeyUsage()[0] && !acIssuerCert.getKeyUsage()[1]) {
            throw new CertPathValidatorException("Attribute certificate issuer public key cannot be used to validate digital signatures.");
        }
        if (acIssuerCert.getBasicConstraints() != -1) {
            throw new CertPathValidatorException("Attribute certificate issuer is also a public key certificate issuer.");
        }
    }

    protected static CertPathValidatorResult a(CertPath certPath, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        CertPathValidator validator;
        try {
            validator = CertPathValidator.getInstance("PKIX", BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (NoSuchProviderException e2) {
            throw new ExtCertPathValidatorException("Support class could not be created.", e2);
        }
        catch (NoSuchAlgorithmException e3) {
            throw new ExtCertPathValidatorException("Support class could not be created.", e3);
        }
        try {
            return validator.validate(certPath, pkixParams);
        }
        catch (CertPathValidatorException e4) {
            throw new ExtCertPathValidatorException("Certification path for issuer certificate of attribute certificate could not be validated.", e4);
        }
        catch (InvalidAlgorithmParameterException e5) {
            throw new RuntimeException(e5.getMessage());
        }
    }

    protected static CertPath c(X509AttributeCertificate attrCert, ExtendedPKIXParameters pkixParams) throws CertPathValidatorException {
        int i2;
        Principal[] principals;
        X509CertStoreSelector selector;
        CertPathBuilderResult result = null;
        HashSet holderPKCs = new HashSet();
        if (attrCert.getHolder().getIssuer() != null) {
            selector = new X509CertStoreSelector();
            selector.setSerialNumber(attrCert.getHolder().getSerialNumber());
            principals = attrCert.getHolder().getIssuer();
            for (i2 = 0; i2 < principals.length; ++i2) {
                try {
                    if (principals[i2] instanceof X500Principal) {
                        selector.setIssuer(((X500Principal)principals[i2]).getEncoded());
                    }
                    holderPKCs.addAll(CertPathValidatorUtilities.findCertificates(selector, pkixParams.getStores()));
                    continue;
                }
                catch (AnnotatedException e2) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", e2);
                }
                catch (IOException e3) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", e3);
                }
            }
            if (holderPKCs.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in base certificate ID for attribute certificate cannot be found.");
            }
        }
        if (attrCert.getHolder().getEntityNames() != null) {
            selector = new X509CertStoreSelector();
            principals = attrCert.getHolder().getEntityNames();
            for (i2 = 0; i2 < principals.length; ++i2) {
                try {
                    if (principals[i2] instanceof X500Principal) {
                        selector.setIssuer(((X500Principal)principals[i2]).getEncoded());
                    }
                    holderPKCs.addAll(CertPathValidatorUtilities.findCertificates(selector, pkixParams.getStores()));
                    continue;
                }
                catch (AnnotatedException e4) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", e4);
                }
                catch (IOException e5) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", e5);
                }
            }
            if (holderPKCs.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in entity name for attribute certificate cannot be found.");
            }
        }
        ExtendedPKIXBuilderParameters params = (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance(pkixParams);
        ExtCertPathValidatorException lastException = null;
        Iterator it = holderPKCs.iterator();
        while (it.hasNext()) {
            CertPathBuilder builder;
            X509CertStoreSelector selector2 = new X509CertStoreSelector();
            selector2.setCertificate((X509Certificate)it.next());
            params.setTargetConstraints(selector2);
            try {
                builder = CertPathBuilder.getInstance("PKIX", BouncyCastleProvider.PROVIDER_NAME);
            }
            catch (NoSuchProviderException e6) {
                throw new ExtCertPathValidatorException("Support class could not be created.", e6);
            }
            catch (NoSuchAlgorithmException e7) {
                throw new ExtCertPathValidatorException("Support class could not be created.", e7);
            }
            try {
                result = builder.build(ExtendedPKIXBuilderParameters.getInstance(params));
            }
            catch (CertPathBuilderException e8) {
                lastException = new ExtCertPathValidatorException("Certification path for public key certificate of attribute certificate could not be build.", e8);
            }
            catch (InvalidAlgorithmParameterException e9) {
                throw new RuntimeException(e9.getMessage());
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return result.getCertPath();
    }

    private static void a(DistributionPoint dp2, X509AttributeCertificate attrCert, ExtendedPKIXParameters paramsPKIX, Date validDate, X509Certificate issuerCert, b certStatus, f reasonMask, List certPathCerts) throws AnnotatedException {
        if (attrCert.getExtensionValue(X509Extensions.NoRevAvail.getId()) != null) {
            return;
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (validDate.getTime() > currentDate.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set crls = CertPathValidatorUtilities.getCompleteCRLs(dp2, attrCert, currentDate, paramsPKIX);
        boolean validCrlFound = false;
        AnnotatedException lastException = null;
        Iterator crl_iter = crls.iterator();
        while (crl_iter.hasNext() && certStatus.b() == 11 && !reasonMask.a()) {
            try {
                X509CRL crl = (X509CRL)crl_iter.next();
                f interimReasonsMask = RFC3280CertPathUtilities.processCRLD(crl, dp2);
                if (!interimReasonsMask.c(reasonMask)) continue;
                Set keys = RFC3280CertPathUtilities.processCRLF(crl, attrCert, null, null, paramsPKIX, certPathCerts);
                PublicKey key = RFC3280CertPathUtilities.processCRLG(crl, keys);
                X509CRL deltaCRL = null;
                if (paramsPKIX.isUseDeltasEnabled()) {
                    Set deltaCRLs = CertPathValidatorUtilities.getDeltaCRLs(currentDate, paramsPKIX, crl);
                    deltaCRL = RFC3280CertPathUtilities.processCRLH(deltaCRLs, key);
                }
                if (paramsPKIX.getValidityModel() != 1 && attrCert.getNotAfter().getTime() < crl.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3280CertPathUtilities.processCRLB1(dp2, attrCert, crl);
                RFC3280CertPathUtilities.processCRLB2(dp2, attrCert, crl);
                RFC3280CertPathUtilities.processCRLC(deltaCRL, crl, paramsPKIX);
                RFC3280CertPathUtilities.processCRLI(validDate, deltaCRL, attrCert, certStatus, paramsPKIX);
                RFC3280CertPathUtilities.processCRLJ(validDate, crl, attrCert, certStatus);
                if (certStatus.b() == 8) {
                    certStatus.a(11);
                }
                reasonMask.a(interimReasonsMask);
                validCrlFound = true;
            }
            catch (AnnotatedException annotatedException) {
                AnnotatedException e2 = annotatedException;
                lastException = annotatedException;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
    }
}

