/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.AccessDescription;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;

public class AuthorityInformationAccess
extends ASN1Object {
    private AccessDescription[] descriptions;

    public static AuthorityInformationAccess getInstance(Object obj) {
        if (obj instanceof AuthorityInformationAccess) {
            return (AuthorityInformationAccess)obj;
        }
        if (obj != null) {
            return new AuthorityInformationAccess(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private AuthorityInformationAccess(ASN1Sequence seq) {
        if (seq.size() <= 0) {
            throw new IllegalArgumentException("sequence may not be empty");
        }
        this.descriptions = new AccessDescription[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            this.descriptions[i2] = AccessDescription.getInstance(seq.getObjectAt(i2));
        }
    }

    public AuthorityInformationAccess(ASN1ObjectIdentifier oid, GeneralName location) {
        this.descriptions = new AccessDescription[1];
        this.descriptions[0] = new AccessDescription(oid, location);
    }

    public AccessDescription[] getAccessDescriptions() {
        return this.descriptions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.descriptions.length; ++i2) {
            vec.add(this.descriptions[i2]);
        }
        return new DERSequence(vec);
    }

    public String toString() {
        return "AuthorityInformationAccess: Oid(" + this.descriptions[0].getAccessMethod().getId() + ")";
    }
}

