/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.macs;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.Mac;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;

public class OldHMac
implements Mac {
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private Digest digest;
    private int digestSize;
    private byte[] inputPad = new byte[64];
    private byte[] outputPad = new byte[64];

    public OldHMac(Digest digest) {
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    @Override
    public void init(CipherParameters params) {
        int i2;
        this.digest.reset();
        byte[] key = ((KeyParameter)params).getKey();
        if (key.length > 64) {
            this.digest.update(key, 0, key.length);
            this.digest.doFinal(this.inputPad, 0);
            for (i2 = this.digestSize; i2 < this.inputPad.length; ++i2) {
                this.inputPad[i2] = 0;
            }
        } else {
            System.arraycopy(key, 0, this.inputPad, 0, key.length);
            for (i2 = key.length; i2 < this.inputPad.length; ++i2) {
                this.inputPad[i2] = 0;
            }
        }
        this.outputPad = new byte[this.inputPad.length];
        System.arraycopy(this.inputPad, 0, this.outputPad, 0, this.inputPad.length);
        i2 = 0;
        while (i2 < this.inputPad.length) {
            int n2 = i2++;
            this.inputPad[n2] = (byte)(this.inputPad[n2] ^ 0x36);
        }
        i2 = 0;
        while (i2 < this.outputPad.length) {
            int n3 = i2++;
            this.outputPad[n3] = (byte)(this.outputPad[n3] ^ 0x5C);
        }
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    @Override
    public int getMacSize() {
        return this.digestSize;
    }

    @Override
    public void update(byte in) {
        this.digest.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = new byte[this.digestSize];
        this.digest.doFinal(tmp, 0);
        this.digest.update(this.outputPad, 0, this.outputPad.length);
        this.digest.update(tmp, 0, tmp.length);
        int len = this.digest.doFinal(out, outOff);
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        this.digest.reset();
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }
}

