/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.signers;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.math.ec.ECAlgorithms;
import com.timevale.tgtext.bouncycastle.math.ec.ECCurve;
import com.timevale.tgtext.bouncycastle.math.ec.ECFieldElement;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSTU4145Signer
implements DSA {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                param = rParam.getParameters();
            } else {
                this.random = new SecureRandom();
            }
            this.key = (ECPrivateKeyParameters)param;
            return;
        }
        this.key = (ECPublicKeyParameters)param;
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s2;
        BigInteger r2;
        ECFieldElement h2 = DSTU4145Signer.hash2FieldElement(this.key.getParameters().getCurve(), message);
        if (h2.toBigInteger().signum() == 0) {
            h2 = this.key.getParameters().getCurve().fromBigInteger(ONE);
        }
        while (true) {
            BigInteger e2 = DSTU4145Signer.generateRandomInteger(this.key.getParameters().getN(), this.random);
            ECFieldElement Fe = this.key.getParameters().getG().multiply(e2).getX();
            if (Fe.toBigInteger().signum() == 0) continue;
            ECFieldElement y2 = h2.multiply(Fe);
            r2 = DSTU4145Signer.fieldElement2Integer(this.key.getParameters().getN(), y2);
            if (r2.signum() != 0 && (s2 = r2.multiply(((ECPrivateKeyParameters)this.key).getD()).add(e2).mod(this.key.getParameters().getN())).signum() != 0) break;
        }
        return new BigInteger[]{r2, s2};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        if (r2.signum() == 0 || s2.signum() == 0) {
            return false;
        }
        if (r2.compareTo(this.key.getParameters().getN()) >= 0 || s2.compareTo(this.key.getParameters().getN()) >= 0) {
            return false;
        }
        ECFieldElement h2 = DSTU4145Signer.hash2FieldElement(this.key.getParameters().getCurve(), message);
        if (h2.toBigInteger().signum() == 0) {
            h2 = this.key.getParameters().getCurve().fromBigInteger(ONE);
        }
        ECPoint R = ECAlgorithms.sumOfTwoMultiplies(this.key.getParameters().getG(), s2, ((ECPublicKeyParameters)this.key).getQ(), r2);
        ECFieldElement y2 = h2.multiply(R.getX());
        return DSTU4145Signer.fieldElement2Integer(this.key.getParameters().getN(), y2).compareTo(r2) == 0;
    }

    private static BigInteger generateRandomInteger(BigInteger n2, SecureRandom random) {
        return new BigInteger(n2.bitLength() - 1, random);
    }

    private static void reverseBytes(byte[] bytes) {
        for (int i2 = 0; i2 < bytes.length / 2; ++i2) {
            byte tmp = bytes[i2];
            bytes[i2] = bytes[bytes.length - 1 - i2];
            bytes[bytes.length - 1 - i2] = tmp;
        }
    }

    private static ECFieldElement hash2FieldElement(ECCurve curve, byte[] hash) {
        byte[] data = Arrays.clone(hash);
        DSTU4145Signer.reverseBytes(data);
        BigInteger num = new BigInteger(1, data);
        while (num.bitLength() >= curve.getFieldSize()) {
            num = num.clearBit(num.bitLength() - 1);
        }
        return curve.fromBigInteger(num);
    }

    private static BigInteger fieldElement2Integer(BigInteger n2, ECFieldElement fieldElement) {
        BigInteger num = fieldElement.toBigInteger();
        while (num.bitLength() >= n2.bitLength()) {
            num = num.clearBit(num.bitLength() - 1);
        }
        return num;
    }
}

