/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime.util;

import com.timevale.tgtext.bouncycastle.mail.smime.util.SharedFileInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.mail.internet.g;
import javax.mail.internet.j;
import javax.mail.q;

public class FileBackedMimeBodyPart
extends j {
    private static final int BUF_SIZE = 32760;
    private final File _file;

    public FileBackedMimeBodyPart(File file) throws q, IOException {
        super((InputStream)new SharedFileInputStream(file));
        this._file = file;
    }

    public FileBackedMimeBodyPart(InputStream inputStream, File file) throws q, IOException {
        this(FileBackedMimeBodyPart.saveStreamToFile(inputStream, file));
    }

    public FileBackedMimeBodyPart(g g2, InputStream inputStream, File file) throws q, IOException {
        this(FileBackedMimeBodyPart.saveStreamToFile(g2, inputStream, file));
    }

    public void writeTo(OutputStream outputStream) throws IOException, q {
        if (!this._file.exists()) {
            throw new IOException("file " + this._file.getCanonicalPath() + " no longer exists.");
        }
        super.writeTo(outputStream);
    }

    public void dispose() throws IOException {
        ((SharedFileInputStream)this.contentStream).getRoot().dispose();
        if (this._file.exists() && !this._file.delete()) {
            throw new IOException("deletion of underlying file <" + this._file.getCanonicalPath() + "> failed.");
        }
    }

    private static File saveStreamToFile(InputStream inputStream, File file) throws IOException {
        FileBackedMimeBodyPart.saveContentToStream(new FileOutputStream(file), inputStream);
        return file;
    }

    private static File saveStreamToFile(g g2, InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Enumeration enumeration = g2.b();
        while (enumeration.hasMoreElements()) {
            FileBackedMimeBodyPart.writeHeader(fileOutputStream, (String)enumeration.nextElement());
        }
        FileBackedMimeBodyPart.writeSeperator(fileOutputStream);
        FileBackedMimeBodyPart.saveContentToStream(fileOutputStream, inputStream);
        return file;
    }

    private static void writeHeader(OutputStream outputStream, String string) throws IOException {
        for (int i2 = 0; i2 != string.length(); ++i2) {
            outputStream.write(string.charAt(i2));
        }
        FileBackedMimeBodyPart.writeSeperator(outputStream);
    }

    private static void writeSeperator(OutputStream outputStream) throws IOException {
        outputStream.write(13);
        outputStream.write(10);
    }

    private static void saveContentToStream(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[32760];
        while ((n2 = inputStream.read(byArray, 0, 32760)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.close();
        inputStream.close();
    }
}

