/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime.examples;

import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMESignedParser;
import com.timevale.tgtext.bouncycastle.mail.smime.util.SharedFileInputStream;
import com.timevale.tgtext.bouncycastle.util.Store;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.ad;
import javax.mail.internet.k;
import javax.mail.internet.l;
import javax.mail.v;

public class ReadLargeSignedMail {
    private static final String BC = BouncyCastleProvider.PROVIDER_NAME;

    private static void verify(SMIMESignedParser sMIMESignedParser) throws Exception {
        Store store = sMIMESignedParser.getCertificates();
        SignerInformationStore signerInformationStore = sMIMESignedParser.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        for (SignerInformation signerInformation : collection) {
            Collection collection2 = store.getMatches(signerInformation.getSID());
            Iterator iterator = collection2.iterator();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(BC).getCertificate((X509CertificateHolder)iterator.next());
            if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(x509Certificate))) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = System.getProperties();
        ad ad2 = ad.b((Properties)properties, null);
        k k2 = new k(ad2, (InputStream)new SharedFileInputStream("signed.message"));
        if (k2.isMimeType("multipart/signed")) {
            SMIMESignedParser sMIMESignedParser = new SMIMESignedParser((l)k2.getContent());
            System.out.println("Status:");
            ReadLargeSignedMail.verify(sMIMESignedParser);
            return;
        }
        if (k2.isMimeType("application/pkcs7-mime")) {
            SMIMESignedParser sMIMESignedParser = new SMIMESignedParser((v)k2);
            System.out.println("Status:");
            ReadLargeSignedMail.verify(sMIMESignedParser);
            return;
        }
        System.err.println("Not a signed message!");
    }
}

