/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.Holder;
import com.timevale.tgtext.bouncycastle.asn1.x509.IssuerSerial;
import com.timevale.tgtext.bouncycastle.asn1.x509.ObjectDigestInfo;
import com.timevale.tgtext.bouncycastle.jce.PrincipalUtil;
import com.timevale.tgtext.bouncycastle.jce.X509Principal;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Selector;
import com.timevale.tgtext.bouncycastle.x509.b;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class AttributeCertificateHolder
implements Selector,
CertSelector {
    final Holder holder;

    AttributeCertificateHolder(ASN1Sequence seq) {
        this.holder = Holder.getInstance(seq);
    }

    public AttributeCertificateHolder(X509Principal issuerName, BigInteger serialNumber) {
        this.holder = new Holder(new IssuerSerial(GeneralNames.getInstance(new DERSequence(new GeneralName(issuerName))), new ASN1Integer(serialNumber)));
    }

    public AttributeCertificateHolder(X500Principal issuerName, BigInteger serialNumber) {
        this(b.a(issuerName), serialNumber);
    }

    public AttributeCertificateHolder(X509Certificate cert) throws CertificateParsingException {
        X509Principal name;
        try {
            name = PrincipalUtil.getIssuerX509Principal(cert);
        }
        catch (Exception e2) {
            throw new CertificateParsingException(e2.getMessage());
        }
        this.holder = new Holder(new IssuerSerial(this.generateGeneralNames(name), new ASN1Integer(cert.getSerialNumber())));
    }

    public AttributeCertificateHolder(X509Principal principal) {
        this.holder = new Holder(this.generateGeneralNames(principal));
    }

    public AttributeCertificateHolder(X500Principal principal) {
        this(b.a(principal));
    }

    public AttributeCertificateHolder(int digestedObjectType, String digestAlgorithm, String otherObjectTypeID, byte[] objectDigest) {
        this.holder = new Holder(new ObjectDigestInfo(digestedObjectType, new ASN1ObjectIdentifier(otherObjectTypeID), new AlgorithmIdentifier(digestAlgorithm), Arrays.clone(objectDigest)));
    }

    public int getDigestedObjectType() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getDigestedObjectType().getValue().intValue();
        }
        return -1;
    }

    public String getDigestAlgorithm() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getDigestAlgorithm().getObjectId().getId();
        }
        return null;
    }

    public byte[] getObjectDigest() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getObjectDigest().getBytes();
        }
        return null;
    }

    public String getOtherObjectTypeID() {
        if (this.holder.getObjectDigestInfo() != null) {
            this.holder.getObjectDigestInfo().getOtherObjectTypeID().getId();
        }
        return null;
    }

    private GeneralNames generateGeneralNames(X509Principal principal) {
        return GeneralNames.getInstance(new DERSequence(new GeneralName(principal)));
    }

    private boolean matchesDN(X509Principal subject, GeneralNames targets) {
        GeneralName[] names = targets.getNames();
        for (int i2 = 0; i2 != names.length; ++i2) {
            GeneralName gn = names[i2];
            if (gn.getTagNo() != 4) continue;
            try {
                if (!new X509Principal(gn.getName().toASN1Primitive().getEncoded()).equals(subject)) continue;
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private Object[] getNames(GeneralName[] names) {
        ArrayList<X500Principal> l2 = new ArrayList<X500Principal>(names.length);
        for (int i2 = 0; i2 != names.length; ++i2) {
            if (names[i2].getTagNo() != 4) continue;
            try {
                l2.add(new X500Principal(names[i2].getName().toASN1Primitive().getEncoded()));
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("badly formed Name object");
            }
        }
        return l2.toArray(new Object[l2.size()]);
    }

    private Principal[] getPrincipals(GeneralNames names) {
        Object[] p2 = this.getNames(names.getNames());
        ArrayList<Object> l2 = new ArrayList<Object>();
        for (int i2 = 0; i2 != p2.length; ++i2) {
            if (!(p2[i2] instanceof Principal)) continue;
            l2.add(p2[i2]);
        }
        return l2.toArray(new Principal[l2.size()]);
    }

    public Principal[] getEntityNames() {
        if (this.holder.getEntityName() != null) {
            return this.getPrincipals(this.holder.getEntityName());
        }
        return null;
    }

    public Principal[] getIssuer() {
        if (this.holder.getBaseCertificateID() != null) {
            return this.getPrincipals(this.holder.getBaseCertificateID().getIssuer());
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        if (this.holder.getBaseCertificateID() != null) {
            return this.holder.getBaseCertificateID().getSerial().getValue();
        }
        return null;
    }

    @Override
    public Object clone() {
        return new AttributeCertificateHolder((ASN1Sequence)this.holder.toASN1Object());
    }

    @Override
    public boolean match(Certificate cert) {
        block12: {
            if (!(cert instanceof X509Certificate)) {
                return false;
            }
            X509Certificate x509Cert = (X509Certificate)cert;
            try {
                MessageDigest md;
                if (this.holder.getBaseCertificateID() != null) {
                    return this.holder.getBaseCertificateID().getSerial().getValue().equals(x509Cert.getSerialNumber()) && this.matchesDN(PrincipalUtil.getIssuerX509Principal(x509Cert), this.holder.getBaseCertificateID().getIssuer());
                }
                if (this.holder.getEntityName() != null && this.matchesDN(PrincipalUtil.getSubjectX509Principal(x509Cert), this.holder.getEntityName())) {
                    return true;
                }
                if (this.holder.getObjectDigestInfo() == null) break block12;
                try {
                    md = MessageDigest.getInstance(this.getDigestAlgorithm(), "BC");
                }
                catch (Exception exception) {
                    return false;
                }
                switch (this.getDigestedObjectType()) {
                    case 0: {
                        md.update(cert.getPublicKey().getEncoded());
                        break;
                    }
                    case 1: {
                        md.update(cert.getEncoded());
                    }
                }
                if (!Arrays.areEqual(md.digest(), this.getObjectDigest())) {
                    return false;
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeCertificateHolder)) {
            return false;
        }
        AttributeCertificateHolder other = (AttributeCertificateHolder)obj;
        return this.holder.equals(other.holder);
    }

    public int hashCode() {
        return this.holder.hashCode();
    }

    @Override
    public boolean match(Object obj) {
        if (!(obj instanceof X509Certificate)) {
            return false;
        }
        return this.match((Certificate)obj);
    }
}

