/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.cms.CompressedData;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.operator.InputExpander;
import com.timevale.tgtext.bouncycastle.operator.InputExpanderProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class CMSCompressedData {
    ContentInfo contentInfo;
    CompressedData comData;

    public CMSCompressedData(byte[] compressedData) throws CMSException {
        this(i.a(compressedData));
    }

    public CMSCompressedData(InputStream compressedData) throws CMSException {
        this(i.a(compressedData));
    }

    public CMSCompressedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            this.comData = CompressedData.getInstance(contentInfo.getContent());
            return;
        }
        catch (ClassCastException e2) {
            throw new CMSException("Malformed content.", e2);
        }
        catch (IllegalArgumentException e3) {
            throw new CMSException("Malformed content.", e3);
        }
    }

    public byte[] getContent() throws CMSException {
        ContentInfo content = this.comData.getEncapContentInfo();
        ASN1OctetString bytes = (ASN1OctetString)content.getContent();
        InflaterInputStream zIn = new InflaterInputStream(bytes.getOctetStream());
        try {
            return i.b(zIn);
        }
        catch (IOException e2) {
            throw new CMSException("exception reading compressed stream.", e2);
        }
    }

    public byte[] getContent(int limit) throws CMSException {
        ContentInfo content = this.comData.getEncapContentInfo();
        ASN1OctetString bytes = (ASN1OctetString)content.getContent();
        InflaterInputStream zIn = new InflaterInputStream(bytes.getOctetStream());
        try {
            return i.a(zIn, limit);
        }
        catch (IOException e2) {
            throw new CMSException("exception reading compressed stream.", e2);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentInfo.getContentType();
    }

    public byte[] getContent(InputExpanderProvider expanderProvider) throws CMSException {
        ContentInfo content = this.comData.getEncapContentInfo();
        ASN1OctetString bytes = (ASN1OctetString)content.getContent();
        InputExpander expander = expanderProvider.get(this.comData.getCompressionAlgorithmIdentifier());
        InputStream zIn = expander.getInputStream(bytes.getOctetStream());
        try {
            return i.b(zIn);
        }
        catch (IOException e2) {
            throw new CMSException("exception reading compressed stream.", e2);
        }
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

