/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.tsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.cms.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.ExtendedKeyUsage;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.timevale.tgtext.bouncycastle.asn1.x509.KeyPurposeId;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.tgtext.bouncycastle.tsp.TSPIOException;
import com.timevale.tgtext.bouncycastle.tsp.TSPValidationException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampTokenInfo;
import com.timevale.tgtext.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TSPUtil {
    private static Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static List EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private static final Map digestLengths = new HashMap();
    private static final Map digestNames = new HashMap();

    public static Collection getSignatureTimestamps(SignerInformation signerInfo, Provider provider) throws TSPValidationException {
        ArrayList<TimeStampToken> timestamps = new ArrayList<TimeStampToken>();
        AttributeTable unsignedAttrs = signerInfo.getUnsignedAttributes();
        if (unsignedAttrs != null) {
            ASN1EncodableVector allTSAttrs = unsignedAttrs.getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            for (int i2 = 0; i2 < allTSAttrs.size(); ++i2) {
                Attribute tsAttr = (Attribute)allTSAttrs.get(i2);
                ASN1Set tsAttrValues = tsAttr.getAttrValues();
                for (int j2 = 0; j2 < tsAttrValues.size(); ++j2) {
                    try {
                        ContentInfo contentInfo = ContentInfo.getInstance(tsAttrValues.getObjectAt(j2));
                        TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
                        TimeStampTokenInfo tstInfo = timeStampToken.getTimeStampInfo();
                        MessageDigest digest = TSPUtil.createDigestInstance(tstInfo.getMessageImprintAlgOID().getId(), provider);
                        byte[] expectedDigest = digest.digest(signerInfo.getSignature());
                        if (!com.timevale.tgtext.bouncycastle.util.Arrays.constantTimeAreEqual(expectedDigest, tstInfo.getMessageImprintDigest())) {
                            throw new TSPValidationException("Incorrect digest in message imprint");
                        }
                        timestamps.add(timeStampToken);
                        continue;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new TSPValidationException("Unknown hash algorithm specified in timestamp");
                    }
                    catch (Exception exception) {
                        throw new TSPValidationException("Timestamp could not be parsed");
                    }
                }
            }
        }
        return timestamps;
    }

    public static Collection getSignatureTimestamps(SignerInformation signerInfo, DigestCalculatorProvider digCalcProvider) throws TSPValidationException {
        ArrayList<TimeStampToken> timestamps = new ArrayList<TimeStampToken>();
        AttributeTable unsignedAttrs = signerInfo.getUnsignedAttributes();
        if (unsignedAttrs != null) {
            ASN1EncodableVector allTSAttrs = unsignedAttrs.getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            for (int i2 = 0; i2 < allTSAttrs.size(); ++i2) {
                Attribute tsAttr = (Attribute)allTSAttrs.get(i2);
                ASN1Set tsAttrValues = tsAttr.getAttrValues();
                for (int j2 = 0; j2 < tsAttrValues.size(); ++j2) {
                    try {
                        ContentInfo contentInfo = ContentInfo.getInstance(tsAttrValues.getObjectAt(j2));
                        TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
                        TimeStampTokenInfo tstInfo = timeStampToken.getTimeStampInfo();
                        DigestCalculator digCalc = digCalcProvider.get(tstInfo.getHashAlgorithm());
                        OutputStream dOut = digCalc.getOutputStream();
                        dOut.write(signerInfo.getSignature());
                        dOut.close();
                        byte[] expectedDigest = digCalc.getDigest();
                        if (!com.timevale.tgtext.bouncycastle.util.Arrays.constantTimeAreEqual(expectedDigest, tstInfo.getMessageImprintDigest())) {
                            throw new TSPValidationException("Incorrect digest in message imprint");
                        }
                        timestamps.add(timeStampToken);
                        continue;
                    }
                    catch (OperatorCreationException operatorCreationException) {
                        throw new TSPValidationException("Unknown hash algorithm specified in timestamp");
                    }
                    catch (Exception exception) {
                        throw new TSPValidationException("Timestamp could not be parsed");
                    }
                }
            }
        }
        return timestamps;
    }

    public static void validateCertificate(X509Certificate cert) throws TSPValidationException {
        if (cert.getVersion() != 3) {
            throw new IllegalArgumentException("Certificate must have an ExtendedKeyUsage extension.");
        }
        byte[] ext = cert.getExtensionValue(X509Extensions.ExtendedKeyUsage.getId());
        if (ext == null) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension.");
        }
        if (!cert.getCriticalExtensionOIDs().contains(X509Extensions.ExtendedKeyUsage.getId())) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension marked as critical.");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(ext));
        try {
            aIn = new ASN1InputStream(new ByteArrayInputStream(((ASN1OctetString)aIn.readObject()).getOctets()));
            ExtendedKeyUsage extKey = ExtendedKeyUsage.getInstance(aIn.readObject());
            if (!extKey.hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping) || extKey.size() != 1) {
                throw new TSPValidationException("ExtendedKeyUsage not solely time stamping.");
            }
            return;
        }
        catch (IOException iOException) {
            throw new TSPValidationException("cannot process ExtendedKeyUsage extension");
        }
    }

    public static void validateCertificate(X509CertificateHolder cert) throws TSPValidationException {
        if (cert.toASN1Structure().getVersionNumber() != 3) {
            throw new IllegalArgumentException("Certificate must have an ExtendedKeyUsage extension.");
        }
        Extension ext = cert.getExtension(Extension.extendedKeyUsage);
        if (ext == null) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension.");
        }
        if (!ext.isCritical()) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension marked as critical.");
        }
        ExtendedKeyUsage extKey = ExtendedKeyUsage.getInstance(ext.getParsedValue());
        if (!extKey.hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping) || extKey.size() != 1) {
            throw new TSPValidationException("ExtendedKeyUsage not solely time stamping.");
        }
    }

    static String getDigestAlgName(String digestAlgOID) {
        String digestName = (String)digestNames.get(digestAlgOID);
        if (digestName != null) {
            return digestName;
        }
        return digestAlgOID;
    }

    static int getDigestLength(String digestAlgOID) throws TSPException {
        Integer length = (Integer)digestLengths.get(digestAlgOID);
        if (length != null) {
            return length;
        }
        throw new TSPException("digest algorithm cannot be found.");
    }

    static MessageDigest createDigestInstance(String digestAlgOID, Provider provider) throws NoSuchAlgorithmException {
        String digestName = TSPUtil.getDigestAlgName(digestAlgOID);
        if (provider != null) {
            try {
                return MessageDigest.getInstance(digestName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return MessageDigest.getInstance(digestName);
    }

    static Set getCriticalExtensionOIDs(X509Extensions extensions) {
        if (extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(extensions.getCriticalExtensionOIDs())));
    }

    static Set getNonCriticalExtensionOIDs(X509Extensions extensions) {
        if (extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(extensions.getNonCriticalExtensionOIDs())));
    }

    static List getExtensionOIDs(Extensions extensions) {
        if (extensions == null) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(extensions.getExtensionOIDs()));
    }

    static void addExtension(ExtensionsGenerator extGenerator, ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws TSPIOException {
        try {
            extGenerator.addExtension(oid, isCritical, value);
            return;
        }
        catch (IOException e2) {
            throw new TSPIOException("cannot encode extension: " + e2.getMessage(), e2);
        }
    }

    static {
        digestLengths.put(PKCSObjectIdentifiers.md5.getId(), Integers.valueOf(16));
        digestLengths.put(OIWObjectIdentifiers.idSHA1.getId(), Integers.valueOf(20));
        digestLengths.put(NISTObjectIdentifiers.id_sha224.getId(), Integers.valueOf(28));
        digestLengths.put(NISTObjectIdentifiers.id_sha256.getId(), Integers.valueOf(32));
        digestLengths.put(NISTObjectIdentifiers.id_sha384.getId(), Integers.valueOf(48));
        digestLengths.put(NISTObjectIdentifiers.id_sha512.getId(), Integers.valueOf(64));
        digestLengths.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), Integers.valueOf(16));
        digestLengths.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), Integers.valueOf(20));
        digestLengths.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), Integers.valueOf(32));
        digestLengths.put(CryptoProObjectIdentifiers.gostR3411.getId(), Integers.valueOf(32));
        digestNames.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        digestNames.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        digestNames.put(NISTObjectIdentifiers.id_sha224.getId(), "SHA224");
        digestNames.put(NISTObjectIdentifiers.id_sha256.getId(), "SHA256");
        digestNames.put(NISTObjectIdentifiers.id_sha384.getId(), "SHA384");
        digestNames.put(NISTObjectIdentifiers.id_sha512.getId(), "SHA512");
        digestNames.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "SHA1");
        digestNames.put(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId(), "SHA224");
        digestNames.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "SHA256");
        digestNames.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), "SHA384");
        digestNames.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "SHA512");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), "RIPEMD128");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), "RIPEMD160");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), "RIPEMD256");
        digestNames.put(CryptoProObjectIdentifiers.gostR3411.getId(), "GOST3411");
    }
}

