/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Boolean;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;

public class DERBoolean
extends ASN1Primitive {
    private static final byte[] TRUE_VALUE = new byte[]{-1};
    private static final byte[] FALSE_VALUE = new byte[]{0};
    private byte[] value;
    public static final ASN1Boolean FALSE = new ASN1Boolean(false);
    public static final ASN1Boolean TRUE = new ASN1Boolean(true);

    public static ASN1Boolean getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Boolean) {
            return (ASN1Boolean)obj;
        }
        if (obj instanceof DERBoolean) {
            if (((DERBoolean)obj).isTrue()) {
                return TRUE;
            }
            return FALSE;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Boolean getInstance(boolean value) {
        if (value) {
            return TRUE;
        }
        return FALSE;
    }

    public static ASN1Boolean getInstance(int value) {
        if (value != 0) {
            return TRUE;
        }
        return FALSE;
    }

    public static DERBoolean getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERBoolean) {
            return DERBoolean.getInstance(o2);
        }
        return ASN1Boolean.fromOctetString(((ASN1OctetString)o2).getOctets());
    }

    DERBoolean(byte[] value) {
        if (value.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        if (value[0] == 0) {
            this.value = FALSE_VALUE;
            return;
        }
        if (value[0] == 255) {
            this.value = TRUE_VALUE;
            return;
        }
        this.value = Arrays.clone(value);
    }

    public DERBoolean(boolean value) {
        this.value = value ? TRUE_VALUE : FALSE_VALUE;
    }

    public boolean isTrue() {
        return this.value[0] != 0;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 3;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(1, this.value);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o2) {
        if (o2 == null || !(o2 instanceof DERBoolean)) {
            return false;
        }
        return this.value[0] == ((DERBoolean)o2).value[0];
    }

    @Override
    public int hashCode() {
        return this.value[0];
    }

    public String toString() {
        if (this.value[0] != 0) {
            return "TRUE";
        }
        return "FALSE";
    }

    static ASN1Boolean fromOctetString(byte[] value) {
        if (value.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        if (value[0] == 0) {
            return FALSE;
        }
        if (value[0] == 255) {
            return TRUE;
        }
        return new ASN1Boolean(value);
    }
}

