/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.OCSPRequest;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.Request;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.TBSRequest;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509CertificateStructure;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.jce.X509Principal;
import com.timevale.tgtext.bouncycastle.ocsp.CertificateID;
import com.timevale.tgtext.bouncycastle.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.ocsp.OCSPReq;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class OCSPReqGenerator {
    private List list = new ArrayList();
    private GeneralName requestorName = null;
    private X509Extensions requestExtensions = null;

    public void addRequest(CertificateID certId) {
        this.list.add(new a(certId, null));
    }

    public void addRequest(CertificateID certId, X509Extensions singleRequestExtensions) {
        this.list.add(new a(certId, singleRequestExtensions));
    }

    public void setRequestorName(X500Principal requestorName) {
        try {
            this.requestorName = new GeneralName(4, new X509Principal(requestorName.getEncoded()));
            return;
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("cannot encode principal: " + e2);
        }
    }

    public void setRequestorName(GeneralName requestorName) {
        this.requestorName = requestorName;
    }

    public void setRequestExtensions(X509Extensions requestExtensions) {
        this.requestExtensions = requestExtensions;
    }

    private OCSPReq generateRequest(DERObjectIdentifier signingAlgorithm, PrivateKey key, X509Certificate[] chain, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException {
        Iterator it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add(((a)it.next()).a());
            }
            catch (Exception e2) {
                throw new OCSPException("exception creating Request", e2);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, (ASN1Sequence)new DERSequence(requests), this.requestExtensions);
        com.timevale.tgtext.bouncycastle.asn1.ocsp.Signature signature = null;
        if (signingAlgorithm != null) {
            DERBitString bitSig;
            Signature sig;
            if (this.requestorName == null) {
                throw new OCSPException("requestorName must be specified if request is signed.");
            }
            try {
                sig = com.timevale.tgtext.bouncycastle.ocsp.a.b(signingAlgorithm.getId(), provider);
                if (random != null) {
                    sig.initSign(key, random);
                } else {
                    sig.initSign(key);
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                NoSuchProviderException e3 = noSuchProviderException;
                throw noSuchProviderException;
            }
            catch (GeneralSecurityException e4) {
                throw new OCSPException("exception creating signature: " + e4, e4);
            }
            try {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                ASN1OutputStream aOut = new ASN1OutputStream(bOut);
                aOut.writeObject(tbsReq);
                sig.update(bOut.toByteArray());
                bitSig = new DERBitString(sig.sign());
            }
            catch (Exception e5) {
                throw new OCSPException("exception processing TBSRequest: " + e5, e5);
            }
            AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier(signingAlgorithm, (ASN1Encodable)DERNull.INSTANCE);
            if (chain != null && chain.length > 0) {
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                try {
                    for (int i2 = 0; i2 != chain.length; ++i2) {
                        v2.add(new X509CertificateStructure((ASN1Sequence)ASN1Primitive.fromByteArray(chain[i2].getEncoded())));
                    }
                }
                catch (IOException e6) {
                    throw new OCSPException("error processing certs", e6);
                }
                catch (CertificateEncodingException e7) {
                    throw new OCSPException("error encoding certs", e7);
                }
                signature = new com.timevale.tgtext.bouncycastle.asn1.ocsp.Signature(sigAlgId, bitSig, new DERSequence(v2));
            } else {
                signature = new com.timevale.tgtext.bouncycastle.asn1.ocsp.Signature(sigAlgId, bitSig);
            }
        }
        return new OCSPReq(new OCSPRequest(tbsReq, signature));
    }

    public OCSPReq generate() throws OCSPException {
        try {
            return this.generateRequest(null, null, null, null, null);
        }
        catch (NoSuchProviderException e2) {
            throw new OCSPException("no provider! - " + e2, e2);
        }
    }

    public OCSPReq generate(String signingAlgorithm, PrivateKey key, X509Certificate[] chain, String provider) throws OCSPException, NoSuchProviderException, IllegalArgumentException {
        return this.generate(signingAlgorithm, key, chain, provider, null);
    }

    public OCSPReq generate(String signingAlgorithm, PrivateKey key, X509Certificate[] chain, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException, IllegalArgumentException {
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("no signing algorithm specified");
        }
        try {
            DERObjectIdentifier oid = com.timevale.tgtext.bouncycastle.ocsp.a.a(signingAlgorithm);
            return this.generateRequest(oid, key, chain, provider, random);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("unknown signing algorithm specified: " + signingAlgorithm);
        }
    }

    public Iterator getSignatureAlgNames() {
        return com.timevale.tgtext.bouncycastle.ocsp.a.a();
    }

    private class a {
        CertificateID a;
        X509Extensions b;

        public a(CertificateID certId, X509Extensions extensions) {
            this.a = certId;
            this.b = extensions;
        }

        public Request a() throws Exception {
            return new Request(this.a.toASN1Object(), Extensions.getInstance(this.b));
        }
    }
}

