/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.cms.KeyTransRecipientId;
import com.timevale.tgtext.bouncycastle.cms.SignerId;
import java.io.IOException;
import java.security.cert.X509CertSelector;

public class JcaSelectorConverter {
    public SignerId getSignerId(X509CertSelector certSelector) {
        try {
            if (certSelector.getSubjectKeyIdentifier() != null) {
                return new SignerId(X500Name.getInstance(certSelector.getIssuerAsBytes()), certSelector.getSerialNumber(), ASN1OctetString.getInstance(certSelector.getSubjectKeyIdentifier()).getOctets());
            }
            return new SignerId(X500Name.getInstance(certSelector.getIssuerAsBytes()), certSelector.getSerialNumber());
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("unable to convert issuer: " + e2.getMessage());
        }
    }

    public KeyTransRecipientId getKeyTransRecipientId(X509CertSelector certSelector) {
        try {
            if (certSelector.getSubjectKeyIdentifier() != null) {
                return new KeyTransRecipientId(X500Name.getInstance(certSelector.getIssuerAsBytes()), certSelector.getSerialNumber(), ASN1OctetString.getInstance(certSelector.getSubjectKeyIdentifier()).getOctets());
            }
            return new KeyTransRecipientId(X500Name.getInstance(certSelector.getIssuerAsBytes()), certSelector.getSerialNumber());
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("unable to convert issuer: " + e2.getMessage());
        }
    }
}

