/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime.examples;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMECapability;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMECapabilityVector;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaCertStore;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMESignedGenerator;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.a;
import javax.mail.ad;
import javax.mail.internet.f;
import javax.mail.internet.j;
import javax.mail.internet.k;
import javax.mail.internet.l;
import javax.mail.m;

public class CreateSignedMail {
    static int serialNo = 1;

    static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo);
    }

    static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        return new SubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException, OperatorCreationException {
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair2.getPrivate();
        PublicKey publicKey2 = keyPair2.getPublic();
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(new X500Name(string2), BigInteger.valueOf(serialNo++), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(string), publicKey);
        jcaX509v3CertificateBuilder.addExtension(X509Extension.subjectKeyIdentifier, false, CreateSignedMail.createSubjectKeyId(publicKey));
        jcaX509v3CertificateBuilder.addExtension(X509Extension.authorityKeyIdentifier, false, CreateSignedMail.createAuthorityKeyId(publicKey2));
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(jcaX509v3CertificateBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider("BC").build(privateKey)));
    }

    public static void main(String[] stringArray) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024, new SecureRandom());
        String string = "O=Bouncy Castle, C=AU";
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate x509Certificate = CreateSignedMail.makeCertificate(keyPair, string, keyPair, string);
        String string2 = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
        X509Certificate x509Certificate2 = CreateSignedMail.makeCertificate(keyPair2, string2, keyPair, string);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate2);
        arrayList.add(x509Certificate);
        JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
        sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
        aSN1EncodableVector.add(new SMIMECapabilitiesAttribute(sMIMECapabilityVector));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(new X500Name(string), x509Certificate2.getSerialNumber());
        aSN1EncodableVector.add(new SMIMEEncryptionKeyPreferenceAttribute(issuerAndSerialNumber));
        SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
        sMIMESignedGenerator.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(aSN1EncodableVector)).build("SHA1withRSA", keyPair2.getPrivate(), x509Certificate2));
        sMIMESignedGenerator.addCertificates(jcaCertStore);
        j j2 = new j();
        j2.setText("Hello world!");
        l l2 = sMIMESignedGenerator.generate(j2);
        Properties properties = System.getProperties();
        ad ad2 = ad.b((Properties)properties, null);
        f f2 = new f("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        f f3 = new f("example@bouncycastle.org");
        k k2 = new k(ad2);
        k2.a((a)f2);
        k2.a(m.a.a, (a)f3);
        k2.e("example signed message");
        k2.setContent((Object)l2, l2.c());
        k2.b_();
        k2.writeTo((OutputStream)new FileOutputStream("signed.message"));
    }
}

