/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mVector
extends Vector {
    private GF2mField field;
    private int[] vector;

    public GF2mVector(GF2mField field, byte[] v2) {
        int d2;
        this.field = new GF2mField(field);
        int count = 1;
        for (d2 = 8; field.getDegree() > d2; d2 += 8) {
            ++count;
        }
        if (v2.length % count != 0) {
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
        this.length = v2.length / count;
        this.vector = new int[this.length];
        count = 0;
        for (int i2 = 0; i2 < this.vector.length; ++i2) {
            for (int j2 = 0; j2 < d2; j2 += 8) {
                int n2 = i2;
                this.vector[n2] = this.vector[n2] | (v2[count++] & 0xFF) << j2;
            }
            if (field.isElementOfThisField(this.vector[i2])) continue;
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
    }

    public GF2mVector(GF2mField field, int[] vector) {
        this.field = field;
        this.length = vector.length;
        for (int i2 = vector.length - 1; i2 >= 0; --i2) {
            if (field.isElementOfThisField(vector[i2])) continue;
            throw new ArithmeticException("Element array is not specified over the given finite field.");
        }
        this.vector = IntUtils.clone(vector);
    }

    public GF2mVector(GF2mVector other) {
        this.field = new GF2mField(other.field);
        this.length = other.length;
        this.vector = IntUtils.clone(other.vector);
    }

    public GF2mField getField() {
        return this.field;
    }

    public int[] getIntArrayForm() {
        return IntUtils.clone(this.vector);
    }

    @Override
    public byte[] getEncoded() {
        int d2;
        int count = 1;
        for (d2 = 8; this.field.getDegree() > d2; d2 += 8) {
            ++count;
        }
        byte[] res = new byte[this.vector.length * count];
        count = 0;
        for (int i2 = 0; i2 < this.vector.length; ++i2) {
            for (int j2 = 0; j2 < d2; j2 += 8) {
                res[count++] = (byte)(this.vector[i2] >>> j2);
            }
        }
        return res;
    }

    @Override
    public boolean isZero() {
        for (int i2 = this.vector.length - 1; i2 >= 0; --i2) {
            if (this.vector[i2] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector add(Vector addend) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector multiply(Permutation p2) {
        int[] pVec = p2.getVector();
        if (this.length != pVec.length) {
            throw new ArithmeticException("permutation size and vector size mismatch");
        }
        int[] result = new int[this.length];
        for (int i2 = 0; i2 < pVec.length; ++i2) {
            result[i2] = this.vector[pVec[i2]];
        }
        return new GF2mVector(this.field, result);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GF2mVector)) {
            return false;
        }
        GF2mVector otherVec = (GF2mVector)other;
        if (!this.field.equals(otherVec.field)) {
            return false;
        }
        return IntUtils.equals(this.vector, otherVec.vector);
    }

    @Override
    public int hashCode() {
        int hash = this.field.hashCode();
        hash = hash * 31 + this.vector.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.vector.length; ++i2) {
            for (int j2 = 0; j2 < this.field.getDegree(); ++j2) {
                int r2 = j2 & 0x1F;
                int bitMask = 1 << r2;
                int coeff = this.vector[i2] & bitMask;
                if (coeff != 0) {
                    buf.append('1');
                    continue;
                }
                buf.append('0');
            }
            buf.append(' ');
        }
        return buf.toString();
    }
}

