/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.DisplayText;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class NoticeReference
extends ASN1Object {
    private DisplayText organization;
    private ASN1Sequence noticeNumbers;

    private static ASN1EncodableVector convertVector(Vector numbers) {
        ASN1EncodableVector av2 = new ASN1EncodableVector();
        Enumeration it = numbers.elements();
        while (it.hasMoreElements()) {
            ASN1Integer di2;
            Object o2 = it.nextElement();
            if (o2 instanceof BigInteger) {
                di2 = new ASN1Integer((BigInteger)o2);
            } else if (o2 instanceof Integer) {
                di2 = new ASN1Integer(((Integer)o2).intValue());
            } else {
                throw new IllegalArgumentException();
            }
            av2.add(di2);
        }
        return av2;
    }

    public NoticeReference(String organization, Vector numbers) {
        this(organization, NoticeReference.convertVector(numbers));
    }

    public NoticeReference(String organization, ASN1EncodableVector noticeNumbers) {
        this(new DisplayText(organization), noticeNumbers);
    }

    public NoticeReference(DisplayText organization, ASN1EncodableVector noticeNumbers) {
        this.organization = organization;
        this.noticeNumbers = new DERSequence(noticeNumbers);
    }

    private NoticeReference(ASN1Sequence as2) {
        if (as2.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + as2.size());
        }
        this.organization = DisplayText.getInstance(as2.getObjectAt(0));
        this.noticeNumbers = ASN1Sequence.getInstance(as2.getObjectAt(1));
    }

    public static NoticeReference getInstance(Object as2) {
        if (as2 instanceof NoticeReference) {
            return (NoticeReference)as2;
        }
        if (as2 != null) {
            return new NoticeReference(ASN1Sequence.getInstance(as2));
        }
        return null;
    }

    public DisplayText getOrganization() {
        return this.organization;
    }

    public ASN1Integer[] getNoticeNumbers() {
        ASN1Integer[] tmp = new ASN1Integer[this.noticeNumbers.size()];
        for (int i2 = 0; i2 != this.noticeNumbers.size(); ++i2) {
            tmp[i2] = ASN1Integer.getInstance(this.noticeNumbers.getObjectAt(i2));
        }
        return tmp;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector av2 = new ASN1EncodableVector();
        av2.add(this.organization);
        av2.add(this.noticeNumbers);
        return new DERSequence(av2);
    }
}

