/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.i;
import java.io.IOException;
import java.util.Enumeration;

public class DLSet
extends ASN1Set {
    private int bodyLength = -1;

    public DLSet() {
    }

    public DLSet(ASN1Encodable obj) {
        super(obj);
    }

    public DLSet(ASN1EncodableVector v2) {
        super(v2, false);
    }

    public DLSet(ASN1Encodable[] a2) {
        super(a2, false);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int length = 0;
            Enumeration e2 = this.getObjects();
            while (e2.hasMoreElements()) {
                Object obj = e2.nextElement();
                length += ((ASN1Encodable)obj).toASN1Primitive().toDLObject().encodedLength();
            }
            this.bodyLength = length;
        }
        return this.bodyLength;
    }

    @Override
    int encodedLength() throws IOException {
        int length = this.getBodyLength();
        return 1 + i.a(length) + length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        ASN1OutputStream dOut = out.getDLSubStream();
        int length = this.getBodyLength();
        out.write(49);
        out.writeLength(length);
        Enumeration e2 = this.getObjects();
        while (e2.hasMoreElements()) {
            Object obj = e2.nextElement();
            dOut.writeObject((ASN1Encodable)obj);
        }
    }
}

