/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util;

import com.timevale.tgtext.bouncycastle.crypto.Digest;

public class WinternitzOTSVerify {
    private Digest messDigestOTS;
    private int w;

    public WinternitzOTSVerify(Digest digest, int w2) {
        this.w = w2;
        this.messDigestOTS = digest;
    }

    public int getSignatureLength() {
        int mdsize = this.messDigestOTS.getDigestSize();
        int size = ((mdsize << 3) + (this.w - 1)) / this.w;
        int logs = this.getLog((size << this.w) + 1);
        return mdsize * (size += (logs + this.w - 1) / this.w);
    }

    public byte[] Verify(byte[] message, byte[] signature) {
        int d2;
        int mdsize = this.messDigestOTS.getDigestSize();
        this.messDigestOTS.update(message, 0, message.length);
        byte[] hash = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(hash, 0);
        int size = ((mdsize << 3) + (this.w - 1)) / this.w;
        int logs = this.getLog((size << this.w) + 1);
        int keysize = size + (logs + this.w - 1) / this.w;
        int testKeySize = mdsize * keysize;
        if (testKeySize != signature.length) {
            return null;
        }
        byte[] testKey = new byte[testKeySize];
        int c2 = 0;
        int counter = 0;
        if (8 % this.w == 0) {
            int test;
            int i2;
            d2 = 8 / this.w;
            int k2 = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            for (i2 = 0; i2 < hash.length; ++i2) {
                for (int j2 = 0; j2 < d2; ++j2) {
                    c2 += test;
                    System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                    for (test = hash[i2] & k2; test < k2; ++test) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                    }
                    System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                    hash[i2] = (byte)(hash[i2] >>> this.w);
                    ++counter;
                }
            }
            c2 = (size << this.w) - c2;
            for (i2 = 0; i2 < logs; i2 += this.w) {
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test = c2 & k2; test < k2; ++test) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c2 >>>= this.w;
                ++counter;
            }
        } else if (this.w < 8) {
            int j3;
            int test;
            long big8;
            int i3;
            d2 = mdsize / this.w;
            int k3 = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            int ii = 0;
            for (i3 = 0; i3 < d2; ++i3) {
                int j4;
                big8 = 0L;
                for (j4 = 0; j4 < this.w; ++j4) {
                    big8 ^= (long)((hash[ii] & 0xFF) << (j4 << 3));
                    ++ii;
                }
                for (j4 = 0; j4 < 8; ++j4) {
                    c2 += test;
                    System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                    for (test = (int)(big8 & (long)k3); test < k3; ++test) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                    }
                    System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                    big8 >>>= this.w;
                    ++counter;
                }
            }
            d2 = mdsize % this.w;
            big8 = 0L;
            for (j3 = 0; j3 < d2; ++j3) {
                big8 ^= (long)((hash[ii] & 0xFF) << (j3 << 3));
                ++ii;
            }
            d2 <<= 3;
            for (j3 = 0; j3 < d2; j3 += this.w) {
                c2 += test;
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test = (int)(big8 & (long)k3); test < k3; ++test) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                big8 >>>= this.w;
                ++counter;
            }
            c2 = (size << this.w) - c2;
            for (i3 = 0; i3 < logs; i3 += this.w) {
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test = c2 & k3; test < k3; ++test) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c2 >>>= this.w;
                ++counter;
            }
        } else if (this.w < 57) {
            long test8;
            int j5;
            int ii;
            long big8;
            int rest;
            int s2;
            d2 = (mdsize << 3) - this.w;
            int k4 = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            int r2 = 0;
            while (r2 <= d2) {
                s2 = r2 >>> 3;
                rest = r2 % 8;
                int f2 = (r2 += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                for (j5 = s2; j5 < f2; ++j5) {
                    big8 ^= (long)((hash[j5] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c2 = (int)((long)c2 + test8);
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test8 = (big8 >>>= rest) & (long)k4; test8 < (long)k4; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                ++counter;
            }
            s2 = r2 >>> 3;
            if (s2 < mdsize) {
                rest = r2 % 8;
                big8 = 0L;
                ii = 0;
                for (j5 = s2; j5 < mdsize; ++j5) {
                    big8 ^= (long)((hash[j5] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c2 = (int)((long)c2 + test8);
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test8 = (big8 >>>= rest) & (long)k4; test8 < (long)k4; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                ++counter;
            }
            c2 = (size << this.w) - c2;
            for (int i4 = 0; i4 < logs; i4 += this.w) {
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test8 = (long)(c2 & k4); test8 < (long)k4; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c2 >>>= this.w;
                ++counter;
            }
        }
        this.messDigestOTS.update(testKey, 0, testKeySize);
        byte[] TKey = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(TKey, 0);
        return TKey;
    }

    public int getLog(int intValue) {
        int log = 1;
        int i2 = 2;
        while (i2 < intValue) {
            i2 <<= 1;
            ++log;
        }
        return log;
    }
}

