/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.EncryptionScheme;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBEParameter;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.JcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.openssl.PEMException;
import com.timevale.tgtext.bouncycastle.openssl.jcajce.a;
import com.timevale.tgtext.bouncycastle.operator.InputDecryptor;
import com.timevale.tgtext.bouncycastle.operator.InputDecryptorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class JceOpenSSLPKCS8DecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public InputDecryptorProvider build(final char[] password) throws OperatorCreationException {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    Cipher cipher;
                    if (a.a(algorithm.getAlgorithm())) {
                        PBES2Parameters params = PBES2Parameters.getInstance(algorithm.getParameters());
                        KeyDerivationFunc func = params.getKeyDerivationFunc();
                        EncryptionScheme scheme = params.getEncryptionScheme();
                        PBKDF2Params defParams = (PBKDF2Params)func.getParameters();
                        int iterationCount = defParams.getIterationCount().intValue();
                        byte[] salt = defParams.getSalt();
                        String oid = scheme.getAlgorithm().getId();
                        SecretKey key = a.a(oid, password, salt, iterationCount);
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(oid);
                        AlgorithmParameters algParams = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createAlgorithmParameters(oid);
                        algParams.init(scheme.getParameters().toASN1Primitive().getEncoded());
                        cipher.init(2, (Key)key, algParams);
                    } else if (a.b(algorithm.getAlgorithm())) {
                        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algorithm.getParameters());
                        PBEKeySpec pbeSpec = new PBEKeySpec(password);
                        SecretKeyFactory secKeyFact = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithm.getAlgorithm().getId());
                        PBEParameterSpec defParams = new PBEParameterSpec(params.getIV(), params.getIterations().intValue());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), defParams);
                    } else if (a.a((DERObjectIdentifier)algorithm.getAlgorithm())) {
                        PBEParameter params = PBEParameter.getInstance(algorithm.getParameters());
                        PBEKeySpec pbeSpec = new PBEKeySpec(password);
                        SecretKeyFactory secKeyFact = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithm.getAlgorithm().getId());
                        PBEParameterSpec defParams = new PBEParameterSpec(params.getSalt(), params.getIterationCount().intValue());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), defParams);
                    } else {
                        throw new PEMException("Unknown algorithm: " + algorithm.getAlgorithm());
                    }
                    return new InputDecryptor(){

                        @Override
                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return algorithm;
                        }

                        @Override
                        public InputStream getInputStream(InputStream encIn) {
                            return new CipherInputStream(encIn, cipher);
                        }
                    };
                }
                catch (IOException e2) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e2.getMessage(), e2);
                }
                catch (GeneralSecurityException e3) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e3.getMessage(), e3);
                }
            }
        };
    }
}

