/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.alibaba.android.bindingx.core.BindingXCore;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.AbstractEventHandler;
import com.alibaba.android.bindingx.core.internal.ExpressionPair;
import com.alibaba.android.bindingx.core.internal.JSMath;
import com.alibaba.android.bindingx.core.internal.OrientationDetector;
import com.alibaba.android.bindingx.core.internal.OrientationEvaluator;
import com.alibaba.android.bindingx.core.internal.Quaternion;
import com.alibaba.android.bindingx.core.internal.Vector3;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BindingXOrientationHandler
extends AbstractEventHandler
implements OrientationDetector.OnOrientationChangedListener {
    private boolean isStarted = false;
    private double mStartAlpha;
    private double mStartBeta;
    private double mStartGamma;
    private double mLastAlpha;
    private double mLastBeta;
    private double mLastGamma;
    private OrientationDetector mOrientationDetector;
    private OrientationEvaluator mEvaluatorX;
    private OrientationEvaluator mEvaluatorY;
    private OrientationEvaluator mEvaluator3D;
    private String mSceneType;
    private LinkedList<Double> mRecordsAlpha = new LinkedList();
    private Vector3 mVectorX = new Vector3(0.0, 0.0, 1.0);
    private Vector3 mVectorY = new Vector3(0.0, 1.0, 1.0);
    private ValueHolder mValueHolder = new ValueHolder(0.0, 0.0, 0.0);

    public BindingXOrientationHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
        if (context != null) {
            this.mOrientationDetector = OrientationDetector.getInstance(context);
        }
    }

    @VisibleForTesting
    BindingXOrientationHandler(Context context, PlatformManager manager, OrientationDetector detector, Object ... extension) {
        super(context, manager, extension);
        this.mOrientationDetector = detector;
    }

    @Override
    public boolean onCreate(@NonNull String sourceRef, @NonNull String eventType) {
        if (this.mOrientationDetector == null) {
            return false;
        }
        this.mOrientationDetector.addOrientationChangedListener(this);
        return this.mOrientationDetector.start(1);
    }

    @Override
    public void onStart(@NonNull String sourceRef, @NonNull String eventType) {
    }

    @Override
    public void onBindExpression(@NonNull String eventType, @Nullable Map<String, Object> globalConfig, @Nullable ExpressionPair exitExpressionPair, @NonNull List<Map<String, Object>> expressionArgs, @Nullable BindingXCore.JavaScriptCallback callback) {
        super.onBindExpression(eventType, globalConfig, exitExpressionPair, expressionArgs, callback);
        String sceneType = null;
        if (globalConfig != null) {
            sceneType = (String)globalConfig.get("sceneType");
            sceneType = TextUtils.isEmpty((CharSequence)sceneType) ? "2d" : sceneType.toLowerCase();
        }
        if (TextUtils.isEmpty(sceneType) || !"2d".equals(sceneType) && !"3d".equals(sceneType)) {
            sceneType = "2d";
        }
        this.mSceneType = sceneType;
        LogProxy.d("[ExpressionOrientationHandler] sceneType is " + sceneType);
        if ("2d".equals(sceneType)) {
            this.mEvaluatorX = new OrientationEvaluator(null, 90.0, null);
            this.mEvaluatorY = new OrientationEvaluator(0.0, null, 90.0);
        } else if ("3d".equals(sceneType)) {
            this.mEvaluator3D = new OrientationEvaluator(null, null, null);
        }
    }

    @Override
    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        this.clearExpressions();
        if (this.mOrientationDetector == null) {
            return false;
        }
        this.fireEventByState("end", this.mLastAlpha, this.mLastBeta, this.mLastGamma, new Object[0]);
        return this.mOrientationDetector.removeOrientationChangedListener(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mOrientationDetector != null) {
            this.mOrientationDetector.removeOrientationChangedListener(this);
            this.mOrientationDetector.stop();
        }
        if (this.mExpressionHoldersMap != null) {
            this.mExpressionHoldersMap.clear();
            this.mExpressionHoldersMap = null;
        }
    }

    @Override
    public void onOrientationChanged(double alpha, double beta, double gamma) {
        alpha = Math.round(alpha);
        beta = Math.round(beta);
        gamma = Math.round(gamma);
        if (alpha == this.mLastAlpha && beta == this.mLastBeta && gamma == this.mLastGamma) {
            return;
        }
        if (!this.isStarted) {
            this.isStarted = true;
            this.fireEventByState("start", alpha, beta, gamma, new Object[0]);
            this.mStartAlpha = alpha;
            this.mStartBeta = beta;
            this.mStartGamma = gamma;
        }
        boolean result = false;
        if ("2d".equals(this.mSceneType)) {
            result = this.calculate2D(alpha, beta, gamma);
        } else if ("3d".equals(this.mSceneType)) {
            result = this.calculate3D(alpha, beta, gamma);
        }
        if (!result) {
            return;
        }
        double x = this.mValueHolder.x;
        double y = this.mValueHolder.y;
        double z = this.mValueHolder.z;
        this.mLastAlpha = alpha;
        this.mLastBeta = beta;
        this.mLastGamma = gamma;
        try {
            if (LogProxy.sEnableLog) {
                LogProxy.d(String.format(Locale.getDefault(), "[OrientationHandler] orientation changed. (alpha:%f,beta:%f,gamma:%f,x:%f,y:%f,z:%f)", alpha, beta, gamma, x, y, z));
            }
            JSMath.applyOrientationValuesToScope(this.mScope, alpha, beta, gamma, this.mStartAlpha, this.mStartBeta, this.mStartGamma, x, y, z);
            if (!this.evaluateExitExpression(this.mExitExpressionPair, this.mScope)) {
                this.consumeExpression(this.mExpressionHoldersMap, this.mScope, "orientation");
            }
        }
        catch (Exception e) {
            LogProxy.e("runtime error", e);
        }
    }

    private boolean calculate2D(double alpha, double beta, double gamma) {
        if (this.mEvaluatorX != null && this.mEvaluatorY != null) {
            this.mRecordsAlpha.add(alpha);
            if (this.mRecordsAlpha.size() > 5) {
                this.mRecordsAlpha.removeFirst();
            }
            this.formatRecords(this.mRecordsAlpha, 360);
            double formatAlpha = (this.mRecordsAlpha.get(this.mRecordsAlpha.size() - 1) - this.mStartAlpha) % 360.0;
            Quaternion quaternionX = this.mEvaluatorX.calculate(alpha, beta, gamma, formatAlpha);
            Quaternion quaternionY = this.mEvaluatorY.calculate(alpha, beta, gamma, formatAlpha);
            this.mVectorX.set(0.0, 0.0, 1.0);
            this.mVectorX.applyQuaternion(quaternionX);
            this.mVectorY.set(0.0, 1.0, 1.0);
            this.mVectorY.applyQuaternion(quaternionY);
            double x = Math.toDegrees(Math.acos(this.mVectorX.x)) - 90.0;
            double y = Math.toDegrees(Math.acos(this.mVectorY.y)) - 90.0;
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isInfinite(x) || Double.isInfinite(y)) {
                return false;
            }
            x = Math.round(x);
            y = Math.round(y);
            this.mValueHolder.x = x;
            this.mValueHolder.y = y;
        }
        return true;
    }

    private boolean calculate3D(double alpha, double beta, double gamma) {
        if (this.mEvaluator3D != null) {
            this.mRecordsAlpha.add(alpha);
            if (this.mRecordsAlpha.size() > 5) {
                this.mRecordsAlpha.removeFirst();
            }
            this.formatRecords(this.mRecordsAlpha, 360);
            double formatAlpha = (this.mRecordsAlpha.get(this.mRecordsAlpha.size() - 1) - this.mStartAlpha) % 360.0;
            Quaternion q = this.mEvaluator3D.calculate(alpha, beta, gamma, formatAlpha);
            if (Double.isNaN(q.x) || Double.isNaN(q.y) || Double.isNaN(q.z) || Double.isInfinite(q.x) || Double.isInfinite(q.y) || Double.isInfinite(q.z)) {
                return false;
            }
            this.mValueHolder.x = q.x;
            this.mValueHolder.y = q.y;
            this.mValueHolder.z = q.z;
        }
        return true;
    }

    private void formatRecords(List<Double> records, int threshold) {
        int l = records.size();
        double times = 0.0;
        if (l > 1) {
            for (int i = 1; i < l; ++i) {
                if (records.get(i - 1) == null || records.get(i) == null) continue;
                if (records.get(i) - records.get(i - 1) < (double)(-threshold / 2)) {
                    times = Math.floor(records.get(i - 1) / (double)threshold) + 1.0;
                    records.set(i, records.get(i) + times * (double)threshold);
                }
                if (!(records.get(i) - records.get(i - 1) > (double)(threshold / 2))) continue;
                records.set(i, records.get(i) - (double)threshold);
            }
        }
    }

    @Override
    protected void onExit(@NonNull Map<String, Object> scope) {
        double alpha = (Double)scope.get("alpha");
        double beta = (Double)scope.get("beta");
        double gamma = (Double)scope.get("gamma");
        this.fireEventByState("exit", alpha, beta, gamma, new Object[0]);
    }

    @Override
    protected void onUserIntercept(String interceptorName, @NonNull Map<String, Object> scope) {
        double alpha = (Double)scope.get("alpha");
        double beta = (Double)scope.get("beta");
        double gamma = (Double)scope.get("gamma");
        this.fireEventByState("interceptor", alpha, beta, gamma, Collections.singletonMap("interceptor", interceptorName));
    }

    private void fireEventByState(String state, double alpha, double beta, double gamma, Object ... extension) {
        if (this.mCallback != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("state", state);
            param.put("alpha", alpha);
            param.put("beta", beta);
            param.put("gamma", gamma);
            param.put("token", this.mToken);
            if (extension != null && extension.length > 0 && extension[0] instanceof Map) {
                param.putAll((Map)extension[0]);
            }
            this.mCallback.callback(param);
            LogProxy.d(">>>>>>>>>>>fire event:(" + state + "," + alpha + "," + beta + "," + gamma + ")");
        }
    }

    @Override
    public void onActivityPause() {
        if (this.mOrientationDetector != null) {
            this.mOrientationDetector.stop();
        }
    }

    @Override
    public void onActivityResume() {
        if (this.mOrientationDetector != null) {
            this.mOrientationDetector.start(1);
        }
    }

    static class ValueHolder {
        double x;
        double y;
        double z;

        ValueHolder() {
        }

        ValueHolder(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

