/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.core.VideoFrame;
import java.nio.ByteBuffer;

public class YuvHelper {
    public static void I420Copy(ByteBuffer srcY, int srcStrideY, ByteBuffer srcU, int srcStrideU, ByteBuffer srcV, int srcStrideV, ByteBuffer dst, int width, int height) {
        int chromaHeight = (height + 1) / 2;
        int chromaWidth = (width + 1) / 2;
        int minSize = width * height + chromaWidth * chromaHeight * 2;
        if (dst.capacity() < minSize) {
            throw new IllegalArgumentException("Expected destination buffer capacity to be at least " + minSize + " was " + dst.capacity());
        }
        boolean startY = false;
        int startU = height * width;
        int startV = startU + chromaHeight * chromaWidth;
        dst.position(0);
        ByteBuffer dstY = dst.slice();
        dst.position(startU);
        ByteBuffer dstU = dst.slice();
        dst.position(startV);
        ByteBuffer dstV = dst.slice();
        YuvHelper.nativeI420Copy(srcY, srcStrideY, srcU, srcStrideU, srcV, srcStrideV, dstY, width, dstU, chromaWidth, dstV, chromaWidth, width, height);
    }

    public static void I420ToNV12(ByteBuffer srcY, int srcStrideY, ByteBuffer srcU, int srcStrideU, ByteBuffer srcV, int srcStrideV, ByteBuffer dst, int width, int height) {
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = (height + 1) / 2;
        int minSize = width * height + chromaWidth * chromaHeight * 2;
        if (dst.capacity() < minSize) {
            throw new IllegalArgumentException("Expected destination buffer capacity to be at least " + minSize + " was " + dst.capacity());
        }
        boolean startY = false;
        int startUV = height * width;
        dst.position(0);
        dst.limit(startUV);
        ByteBuffer dstY = dst.slice();
        dst.position(startUV);
        dst.limit(minSize);
        ByteBuffer dstUV = dst.slice();
        YuvHelper.nativeI420ToNV12(srcY, srcStrideY, srcU, srcStrideU, srcV, srcStrideV, dstY, width, dstUV, chromaWidth * 2, width, height);
    }

    public static void I420ToNV21(ByteBuffer srcY, int srcStrideY, ByteBuffer srcU, int srcStrideU, ByteBuffer srcV, int srcStrideV, ByteBuffer dst, int width, int height) {
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = (height + 1) / 2;
        int minSize = width * height + chromaWidth * chromaHeight * 2;
        if (dst.capacity() < minSize) {
            throw new IllegalArgumentException("Expected destination buffer capacity to be at least " + minSize + " was " + dst.capacity());
        }
        boolean startY = false;
        int startVU = height * width;
        dst.position(0);
        ByteBuffer dstY = dst.slice();
        dst.position(startVU);
        ByteBuffer dstVU = dst.slice();
        YuvHelper.nativeI420ToNV21(srcY, srcStrideY, srcU, srcStrideU, srcV, srcStrideV, dstY, width, dstVU, chromaWidth * 2, width, height);
    }

    public static void I420Rotate(ByteBuffer srcY, int srcStrideY, ByteBuffer srcU, int srcStrideU, ByteBuffer srcV, int srcStrideV, ByteBuffer dst, int srcWidth, int srcHeight, int rotationMode) {
        int dstWidth = rotationMode % 180 == 0 ? srcWidth : srcHeight;
        int dstHeight = rotationMode % 180 == 0 ? srcHeight : srcWidth;
        int dstChromaHeight = (dstHeight + 1) / 2;
        int dstChromaWidth = (dstWidth + 1) / 2;
        int minSize = dstWidth * dstHeight + dstChromaWidth * dstChromaHeight * 2;
        if (dst.capacity() < minSize) {
            throw new IllegalArgumentException("Expected destination buffer capacity to be at least " + minSize + " was " + dst.capacity());
        }
        boolean startY = false;
        int startU = dstHeight * dstWidth;
        int startV = startU + dstChromaHeight * dstChromaWidth;
        dst.position(0);
        ByteBuffer dstY = dst.slice();
        dst.position(startU);
        ByteBuffer dstU = dst.slice();
        dst.position(startV);
        ByteBuffer dstV = dst.slice();
        YuvHelper.nativeI420Rotate(srcY, srcStrideY, srcU, srcStrideU, srcV, srcStrideV, dstY, dstWidth, dstU, dstChromaWidth, dstV, dstChromaWidth, srcWidth, srcHeight, rotationMode);
    }

    public static void copyPlane(ByteBuffer src, int srcStride, ByteBuffer dst, int dstStride, int width, int height) {
        YuvHelper.nativeCopyPlane(src, srcStride, dst, dstStride, width, height);
    }

    public static ByteBuffer[] I420CopyPlane(VideoFrame.I420Buffer buffer) {
        int[] strides = new int[]{buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV()};
        ByteBuffer[] planes = new ByteBuffer[]{buffer.getDataY(), buffer.getDataU(), buffer.getDataV()};
        int width = buffer.getWidth();
        int height = buffer.getHeight();
        int[] planeWidths = new int[]{width, width / 2, width / 2};
        int[] planeHeights = new int[]{height, height / 2, height / 2};
        int copyCapacityNeeded = 0;
        for (int i = 0; i < 3; ++i) {
            if (strides[i] <= planeWidths[i]) continue;
            copyCapacityNeeded = Math.max(copyCapacityNeeded, planeWidths[i] * planeHeights[i]);
        }
        ByteBuffer[] outPlanes = new ByteBuffer[3];
        for (int i = 0; i < 3; ++i) {
            ByteBuffer packedByteBuffer;
            if (strides[i] == planeWidths[i]) {
                packedByteBuffer = planes[i];
            } else {
                packedByteBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
                YuvHelper.copyPlane(planes[i], strides[i], packedByteBuffer, planeWidths[i], planeWidths[i], planeHeights[i]);
            }
            outPlanes[i] = packedByteBuffer;
        }
        return outPlanes;
    }

    public static void I420Copy(ByteBuffer srcY, int srcStrideY, ByteBuffer srcU, int srcStrideU, ByteBuffer srcV, int srcStrideV, ByteBuffer dstY, int dstStrideY, ByteBuffer dstU, int dstStrideU, ByteBuffer dstV, int dstStrideV, int width, int height) {
        YuvHelper.nativeI420Copy(srcY, srcStrideY, srcU, srcStrideU, srcV, srcStrideV, dstY, dstStrideY, dstU, dstStrideU, dstV, dstStrideV, width, height);
    }

    public static void I420ToNV12(ByteBuffer srcY, int srcStrideY, ByteBuffer srcU, int srcStrideU, ByteBuffer srcV, int srcStrideV, ByteBuffer dstY, int dstStrideY, ByteBuffer dstUV, int dstStrideUV, int width, int height) {
        YuvHelper.nativeI420ToNV12(srcY, srcStrideY, srcU, srcStrideU, srcV, srcStrideV, dstY, dstStrideY, dstUV, dstStrideUV, width, height);
    }

    public static void I420Rotate(ByteBuffer srcY, int srcStrideY, ByteBuffer srcU, int srcStrideU, ByteBuffer srcV, int srcStrideV, ByteBuffer dstY, int dstStrideY, ByteBuffer dstU, int dstStrideU, ByteBuffer dstV, int dstStrideV, int srcWidth, int srcHeight, int rotationMode) {
        YuvHelper.nativeI420Rotate(srcY, srcStrideY, srcU, srcStrideU, srcV, srcStrideV, dstY, dstStrideY, dstU, dstStrideU, dstV, dstStrideV, srcWidth, srcHeight, rotationMode);
    }

    public static void I420ToRGBA(ByteBuffer srcY, int srcStrideY, ByteBuffer srcU, int srcStrideU, ByteBuffer srcV, int srcStrideV, ByteBuffer dstData, int width, int height) {
        YuvHelper.nativeI420ToRGBA(srcY, srcStrideY, srcU, srcStrideU, srcV, srcStrideV, dstData, width * 4, width, height);
    }

    public static void RGBAToI420(ByteBuffer srcRGBA, ByteBuffer dstY, int dstStrideY, ByteBuffer dstU, int dstStrideU, ByteBuffer dstV, int dstStrideV, int width, int height) {
        YuvHelper.nativeRGBAToI420(srcRGBA, width * 4, dstY, dstStrideY, dstU, dstStrideU, dstV, dstStrideV, width, height);
    }

    public static void NV21ToRGBA(ByteBuffer srcY, int srcStrideY, ByteBuffer srcUV, int srcStrideUV, ByteBuffer dstData, int width, int height) {
        YuvHelper.nativeNV21ToRGBA(srcY, srcStrideY, srcUV, srcStrideUV, dstData, width * 4, width, height);
    }

    private static native void nativeCopyPlane(ByteBuffer var0, int var1, ByteBuffer var2, int var3, int var4, int var5);

    private static native void nativeI420Copy(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, ByteBuffer var8, int var9, ByteBuffer var10, int var11, int var12, int var13);

    private static native void nativeI420ToNV12(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, ByteBuffer var8, int var9, int var10, int var11);

    private static native void nativeI420ToNV21(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, ByteBuffer var8, int var9, int var10, int var11);

    private static native void nativeI420Rotate(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, ByteBuffer var8, int var9, ByteBuffer var10, int var11, int var12, int var13, int var14);

    private static native void nativeI420ToRGBA(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, int var8, int var9);

    private static native void nativeRGBAToI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, int var8, int var9);

    private static native void nativeNV21ToRGBA(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7);
}

