/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.util;

import com.ksyun.ks3.services.request.adp.Adp;
import com.ksyun.ks3.util.Base64;
import com.ksyun.ks3.util.RequestUtils;
import com.ksyun.ks3.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static String urlEncode(String value, boolean path) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = "%20";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                } else if (path && "%2F".equals(replacement)) {
                    replacement = "/";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            encoded = buffer.toString();
            return encoded;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encodeParams(Map<String, String> params) {
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(params.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : arrayList) {
            String value = null;
            String key = ((String)entry.getKey()).replace(String.valueOf('\u200b'), "");
            if (!StringUtils.isBlank((String)entry.getValue())) {
                value = URLEncoder.encode((String)entry.getValue());
            }
            if (value != null && !value.equals("")) {
                list.add(key + "=" + value);
                continue;
            }
            if (value == null) {
                list.add(key + "=");
                continue;
            }
            if (!RequestUtils.subResource.contains(key)) continue;
            list.add(key);
        }
        String queryParams = StringUtils.join(list.toArray(), "&");
        return queryParams;
    }

    public static String convertAdps2String(List<Adp> fops) {
        StringBuffer fopStringBuffer = new StringBuffer();
        for (Adp fop : fops) {
            fopStringBuffer.append(fop.getCommand());
            if (!StringUtils.isBlank(fop.getBucket()) || !StringUtils.isBlank(fop.getKey())) {
                if (StringUtils.isBlank(fop.getBucket())) {
                    fopStringBuffer.append(String.format("|tag=saveas&object=%s", Base64.encode(fop.getKey().getBytes())));
                } else if (StringUtils.isBlank(fop.getKey())) {
                    fopStringBuffer.append(String.format("|tag=saveas&bucket=%s", fop.getBucket()));
                } else {
                    fopStringBuffer.append(String.format("|tag=saveas&bucket=%s&object=%s", fop.getBucket(), Base64.encode(fop.getKey().getBytes())));
                }
            }
            fopStringBuffer.append(";");
        }
        String fopString = fopStringBuffer.toString();
        if (fopString.endsWith(";")) {
            fopString = fopString.substring(0, fopString.length() - 1);
        }
        return fopString;
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

