/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.weex;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.feature.weex.WeexInstanceMgr;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONObject;

public class DCFileUtils {
    public static InputStream loadWeexAsset(String path, Context context) {
        InputStream inputStream = AppRuntime.loadWeexAsset((String)path, (Context)context);
        if (inputStream != null) {
            return inputStream;
        }
        if (path.startsWith("uni-jsframework") && path.endsWith(".js")) {
            try {
                InputStream io = null;
                try {
                    io = context.getAssets().open(path);
                }
                catch (FileNotFoundException e) {
                    WeexInstanceMgr.self().setJSFKFileNotFound(true);
                }
                if (io != null) {
                    WeexInstanceMgr.self().setJSFKFileNotFound(false);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(io));
                    String line = reader.readLine();
                    JSONObject object = new JSONObject(line.substring(2));
                    BaseInfo.uniVersionV3 = object.optString("version");
                    String encode = object.optString("encode");
                    if (!TextUtils.isEmpty((CharSequence)encode) && encode.equals("base64")) {
                        String js = reader.readLine();
                        String tempStr = null;
                        while ((tempStr = reader.readLine()) != null) {
                            js = js + tempStr;
                        }
                        tempStr = null;
                        byte[] data = Base64.decode((String)js, (int)0);
                        inputStream = new ByteArrayInputStream(data);
                    }
                } else {
                    WeexInstanceMgr.self().setJSFKFileNotFound(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return inputStream;
    }

    public static String getAssetPath(String path) {
        if (!TextUtils.isEmpty((CharSequence)path) && path.equals("weex-main-jsfm.js")) {
            boolean isVue3;
            String devPath = "uni-jsframework";
            boolean bl = isVue3 = WeexInstanceMgr.self().getVueVersion() == 3;
            if (isVue3) {
                devPath = devPath + "-vue3";
            }
            if (PlatformUtil.getResInputStream((String)(path = BaseInfo.SyncDebug ? devPath + "-dev.js" : devPath + ".js")) == null && BaseInfo.SyncDebug) {
                path = devPath + ".js";
            }
            Logger.i((String)"DCFileUtils", (String)("getAssetPath---------" + path));
        }
        return path;
    }
}

