/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class RTCCodecInfo {
    private static final String TAG = "RTCCodecInfo";
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int COLOR_FormatYUV420Flexible = 2135033992;

    private RTCCodecInfo() {
    }

    public static RTCCodecInfo getInstance() {
        return SingletonHolder.info;
    }

    public String getMediaCodecInfo() {
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
                JSONObject Codecinfo = new JSONObject();
                if (info == null) continue;
                Codecinfo.put("codecName", (Object)info.getName());
                JSONArray mediaTypeArray = new JSONArray();
                for (String mimeType : info.getSupportedTypes()) {
                    JSONObject mediaTypeObject = new JSONObject();
                    mediaTypeObject.put("mimeType", (Object)mimeType);
                    try {
                        MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(mimeType);
                        JSONArray colorFormatArray = new JSONArray();
                        if (capabilities != null) {
                            for (int codecColorFormat : capabilities.colorFormats) {
                                JSONObject jsonObject_colorFormat = new JSONObject();
                                jsonObject_colorFormat.put("color", codecColorFormat);
                                jsonObject_colorFormat.put("alias", (Object)RTCCodecInfo.getCodecCapabilities(codecColorFormat));
                                colorFormatArray.put((Object)jsonObject_colorFormat);
                            }
                        }
                        mediaTypeObject.put("colorFormats", (Object)colorFormatArray);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    mediaTypeArray.put((Object)mediaTypeObject);
                }
                Codecinfo.put("mediaTypes", (Object)mediaTypeArray);
                jsonArray.put((Object)Codecinfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        try {
            RTCCodecInfo.show(jsonArray.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonArray.toString();
    }

    private static String getCodecCapabilities(int val) {
        String result = "";
        switch (val) {
            case 2130706688: {
                result = "COLOR_TI_FormatYUV420PackedSemiPlanar";
                break;
            }
            case 19: {
                result = "COLOR_FormatYUV420Planar";
                break;
            }
            case 2141391872: {
                result = "COLOR_QCOM_FormatYUV420SemiPlanar";
                break;
            }
            case 21: {
                result = "COLOR_FormatYUV420SemiPlanar";
                break;
            }
            case 2141391873: {
                result = "COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka";
                break;
            }
            case 2141391874: {
                result = "COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka";
                break;
            }
            case 2141391875: {
                result = "COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka";
                break;
            }
            case 2141391876: {
                result = "COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m";
                break;
            }
            case 2135033992: {
                result = "COLOR_FormatYUV420Flexible";
                break;
            }
            case 2130708361: {
                result = "COLOR_FormatSurface";
                break;
            }
            default: {
                result = "0x" + Integer.toHexString(val);
            }
        }
        return result;
    }

    private static void show(String str) {
        str = str.trim();
        int maxLength = 4000;
        for (int index = 0; index < str.length(); index += maxLength) {
            String sub = str.length() <= index + maxLength ? str.substring(index) : str.substring(index, maxLength);
            Log.i((String)TAG, (String)sub.trim());
        }
    }

    private static class SingletonHolder {
        static RTCCodecInfo info = new RTCCodecInfo();

        private SingletonHolder() {
        }
    }
}

