/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext.node;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ui.component.richtext.node.ANode;
import com.taobao.weex.ui.component.richtext.node.ImgNode;
import com.taobao.weex.ui.component.richtext.node.RichTextNode;
import com.taobao.weex.ui.component.richtext.node.RichTextNodeCreator;
import com.taobao.weex.ui.component.richtext.node.SpanNode;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Map;

public class RichTextNodeManager {
    private static final Map<String, RichTextNodeCreator> registeredTextNodes = new ArrayMap();

    public static void registerTextNode(String text, RichTextNodeCreator type) {
        registeredTextNodes.put(text, type);
    }

    @Nullable
    static RichTextNode createRichTextNode(@NonNull Context context, @NonNull String instanceId, @NonNull String componentRef, @Nullable JSONObject jsonObject) {
        RichTextNode instance = null;
        try {
            if (jsonObject != null) {
                instance = (RichTextNode)registeredTextNodes.get(jsonObject.getString("type")).createRichTextNode(context, instanceId, componentRef);
                instance.parse(context, instanceId, componentRef, jsonObject);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("Richtext", WXLogUtils.getStackTrace(e));
            instance = null;
        }
        return instance;
    }

    public static RichTextNode createRichTextNode(Context context, String instanceId, String componentRef, String ref, String nodeType, Map<String, String> styles, Map<String, String> attrs) {
        RichTextNode instance;
        try {
            instance = (RichTextNode)registeredTextNodes.get(nodeType).createRichTextNode(context, instanceId, componentRef, ref, styles, attrs);
        }
        catch (Exception e) {
            WXLogUtils.e("Richtext", WXLogUtils.getStackTrace(e));
            instance = null;
        }
        return instance;
    }

    static {
        registeredTextNodes.put("span", new SpanNode.SpanNodeCreator());
        registeredTextNodes.put("image", new ImgNode.ImgNodeCreator());
        registeredTextNodes.put("a", new ANode.ANodeCreator());
    }
}

